// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: UcharDI.h,v $
// Revision 1.8  1994/01/31  15:50:03  thoth
// read_PGM now can return the maxval.
//
// Revision 1.7  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.6  1993/12/29  17:05:11  thoth
// Workaround for woejus CFront bug.
// write_PGM functions will no longer calculate a maxval of 0.
//
// Revision 1.5  1993/11/17  18:28:34  thoth
// write_PGM friend functions now accept Image<IntPoint, u_char> & arguments.
//
// Revision 1.4  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.3  1993/09/27  15:56:11  thoth
// op= with a constant now works.
//
// Revision 1.2  1993/09/24  11:37:21  jnw
// Added display function.
//
// Revision 1.1  93/09/15  12:57:32  thoth
// Initial revision
// 
// Revision 1.4  93/05/31  15:56:45  thoth
// write_PGM now supports maxval.
// 
// Revision 1.3  93/05/27  11:22:43  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:41:34  thoth
// IDM interface for Uchar DIs.
// 
// Revision 1.1  93/03/18  11:17:14  thoth
// Initial revision
// 

#ifndef UcharDI_h_
#define UcharDI_h_

#include <sys/stdtypes.h>
#include "CoreImage.h"
#include "ImageDisplayProtocol.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

#include	<complex.h>	// for the complex conversion
#include "Bit.h"		// for the to_bit converter function

class IA_Image<IA_IntPoint,u_char>: public IA_CoreImage<IA_IntPoint,u_char>
{
  public:
    IA_Image():IA_CoreImage<IA_IntPoint,u_char>() {}

    IA_Image(const IA_Image& im)
    :IA_CoreImage<IA_IntPoint,u_char>(im) {}

    IA_Image(IA_IntPointSet ps, u_char value)
    :IA_CoreImage<IA_IntPoint,u_char>(ps,value) {}

    IA_Image(IA_IntPointSet ps, u_char *vp, unsigned sz,
			int giveaway=0)
    :IA_CoreImage<IA_IntPoint,u_char>(ps, vp, sz, giveaway) {}

    IA_Image(const IA_ClosureI<IA_IntPoint,u_char> &img)
    :IA_CoreImage<IA_IntPoint,u_char>(img) {}

    IA_Image(IA_IntPointSet ps, u_char (*f)(const IA_IntPoint&))
    :IA_CoreImage<IA_IntPoint,u_char>(ps,f) {}

    IA_Image( const IA_CoreImage<IA_IntPoint,u_char> &d)
    :IA_CoreImage<IA_IntPoint,u_char>(d) {}

    virtual ~IA_Image(){ }

    IA_Image& operator=(int v) {
	(IA_CoreImage<IA_IntPoint,u_char>&)*this = v;
	return *this;
    }
#include	"UcharImageOps.h"

    static IA_Image read_PGM(istream &, int *maxval=0);
    static IA_Image read_PGM(const char *fname, int *maxval=0);

    ostream& write_PGM(ostream &, unsigned) const;
    ostream& write_PGM(ostream &) const;
    void write_PGM(const char *fname, unsigned) const;
    void write_PGM(const char *fname) const;


    void IDM_display(IDP::LinkID, const char *label=0);
};

inline int operator!=(const IA_CoreImage<IA_IntPoint,u_char> &lhs,
	       const IA_CoreImage<IA_IntPoint,u_char> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_CoreImage<IA_IntPoint,u_char> &lhs, int rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(int lhs, const IA_CoreImage<IA_IntPoint,u_char> &rhs) {
    return ! (rhs == lhs);
}

//
//

inline ostream& write_PGM(const IA_CoreImage<IA_IntPoint,u_char> &im, ostream &o, unsigned max) {
    return IA_Image<IA_IntPoint,u_char>(im).write_PGM(o, max);
}

inline ostream& write_PGM(const IA_CoreImage<IA_IntPoint,u_char> &im, ostream &o) {
    return IA_Image<IA_IntPoint,u_char>(im).write_PGM(o);
}

inline void write_PGM(const IA_CoreImage<IA_IntPoint,u_char> &im, const char *fname) {
    IA_Image<IA_IntPoint,u_char>(im).write_PGM(fname);
}

inline void write_PGM(const IA_CoreImage<IA_IntPoint,u_char> &im,
		      const char *fname, unsigned max) {
    IA_Image<IA_IntPoint,u_char>(im).write_PGM(fname, max);
}

//
//

pid_t display(IA_CoreImage<IA_IntPoint,u_char> img);

// compiler clue to allow inexact matches on a function template
//ostream& operator <<(ostream&, const IA_CoreImage<IA_IntPoint,u_char>&);


#endif
