// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: Neighborhood.h,v $
// Revision 1.1  1994/01/31  16:50:30  thoth
// Initial revision
//

#ifndef Neighborhood_h_
#define Neighborhood_h_

#include "BaseNbh.h"
#include "Image.h"

template <class P, class Q>
class IA_Neighborhood {
protected:
    IA_BaseNbh<P,Q>	*bnbh;

    void set_and_reference(IA_BaseNbh<P,Q> *);
    void disassociate();

public:
    IA_Neighborhood(unsigned dim, const IA_Set<P> & ps);
    IA_Neighborhood(const IA_Neighborhood &);

    ~IA_Neighborhood();

    IA_Neighborhood& operator=(const IA_Neighborhood &);

    IA_Set<P> operator()(const Q &p) const { return (*bnbh)(p); }

    IA_Set<Q> domain() const { return bnbh->domain(); }
    IA::Type type() const { return bnbh->type(); }

#include "NeighborhoodOps.h"
};

#endif // Neighborhood_h_
