// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ConstI.h,v $
// Revision 1.2  1993/11/17  18:12:47  thoth
// extensivep is now extensive
//
// Revision 1.1  1993/09/15  12:51:13  thoth
// Initial revision
//

#ifndef ConstI_h_
#define ConstI_h_

#include "BaseI.h"

template < class P,class T> class IA_ConstIVIter;
template < class P,class T> class IA_ConstIPIter;

template < class P,class T>
class IA_ConstI: public IA_BaseImage<P,T> {
public:
    static char dummy;

    T value;
public:
    IA_ConstI(const IA_Set<P>& p, const T& val)
    : IA_BaseImage<P,T>(p), value(val) { }

    int extensive() const { return 0; }

    T operator ()(const P &) const { return value; }

    // ~IA_ConstI() {}

    static IA_ImageType s_type() { return &dummy; }

    IA_ImageType type() const { return &dummy; }

    IA_BaseImage<P,T>* clone_self_extensively() const;

    IA_ValueSet<T> range() const;

    IA_Array<T> value_array() const;

#if 0
    IA_BaseImage<IA_IntPoint,T> * restricted_to(const IA_IntPointSet &ps) const
#if 1
	;
#else
    {
	return new IA_ConstI<IA_IntPoint,T>(this->domain() & ps, this->value);
    }
#endif

    IA_BaseImage<P,T> * restricted_to(const IA_FloatPointSet &ps) const
#if 1
    ;
#else
    {
	return new IA_ConstI<P,T>(this->domain() & ps, this->value);
    }
#endif
#endif
    
    IA_BaseImage<P,T> * xlated_by(const P &p) const {
	return new IA_ConstI<P,T>(this->domain()+p, this->value);
    }

    IA_BaseIVIter<P,T> *value_iterator() const;
    IA_BaseIPIter<P,T> *pixel_iterator() const;

    ostream& print_this(ostream&) const;

    friend class IA_ConstIVIter<P,T>;
    friend class IA_ConstIPIter<P,T>;
};

#endif
