// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ConstI.c,v $
// Revision 1.2  1993/11/17  18:13:40  thoth
// IPSIter is now PSIter<IntPoint>.
// extensivep is now extensive.
//
// Revision 1.1  1993/09/15  12:50:48  thoth
// Initial revision
//

#include "VectorI.h"
#include "ConstI.h"
#include "ConstImageIter.h"
#include "PSIter.h"

template < class P,class T>
char IA_ConstI<P,T>::dummy;

template < class P,class T>
IA_BaseImage<P,T>* IA_ConstI<P,T>::clone_self_extensively() const
{
    // VectorDI will throw if the pointset is nonextensive
    return (IA_BaseImage<P,T> *) new IA_VectorI<P,T>(this->ps, this->value);
}

#if 1
template < class P,class T>
IA_ValueSet<T> IA_ConstI<P,T>::range() const
{
    return value;
}
#else
template < class P,class T>
T* IA_ConstI<P,T>::range(unsigned *sz) const
{
    T	*vec = new T[*sz=1];
    vec[0] = value;
    return vec;
}
#endif
template < class P,class T>
IA_Array<T> IA_ConstI<P,T>::value_array() const
{
    const int	sz=domain().card();
    T	*vec = new T[sz];
    for (int i=0; i<sz; i++)
	vec[i] = value;
    return IA_Array<T>(vec,sz,1);
}



#if 0
template <class T>
IA_BaseImage<IA_IntPoint,T> * IA_ConstI<IA_IntPoint,T>::restricted_to(const IA_IntPointSet &ps) const
{
    return new IA_ConstI<IA_IntPoint,T>(this->domain() & ps, this->value);
}
#endif

//
// iterator support below
//

template < class P,class T>
IA_BaseIVIter<P,T> *IA_ConstI<P,T>::value_iterator() const
{
    return new IA_ConstIVIter<P,T>(this);
}

template < class P,class T>
IA_BaseIPIter<P,T> *IA_ConstI<P,T>::pixel_iterator() const
{
    return new IA_ConstIPIter<P,T>(this);
}

//
//
//

template < class P,class T>
ostream& IA_ConstI<P,T>::print_this(ostream &o) const
{
    o << "Constant Image - Value : " << this->value ;
    if (this->ps.extensive()){
	IA_PSIter<P> iter(this->ps);
	P p;
	o << ", Points follow\n";
	while(iter(p)) {
	    o << p << ", ";
	}
    } else {
	o << ", Comprehensive PointSet";
    }
    return o << "\n";
}
