// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: Array.h,v $
// Revision 1.4  1993/06/10  16:47:35  thoth
// Let the system define abort().
//
// Revision 1.3  93/05/26  16:28:21  thoth
// Copyright Notices.
// 
// Revision 1.2  93/05/19  14:42:34  thoth
// Renamed to IA_Array.
// new operator() which is const.
// 
// Revision 1.1  92/10/27  16:34:51  thoth
// Initial revision
// 
//

#ifndef Array_h_
#define Array_h_

#include <stdlib.h>

template <class T>
class IA_Array {
private:
  T	*data;
  unsigned length;
  unsigned size;
public:
  IA_Array(unsigned size_=16);
  IA_Array(T*data_, unsigned size_, int giveaway=0);
  IA_Array(const IA_Array&);
  IA_Array& operator=(const IA_Array&);
  ~IA_Array() { delete[] data; }

  T& operator[](unsigned);
  T operator[](unsigned) const;
  T operator()(unsigned) const;
  T& after_last() { return (*this)[length]; }
  T& last() {
      if (length<1)
	  abort();
      return (*this)[length-1];
  }
  T last() const { return (*this)[length-1]; }

  T* data_start() { return data; }
  const T* data_start() const { return data; }

  unsigned len() const { return length; }
  unsigned shorten(unsigned newlen);
  unsigned lengthen(unsigned newlen);
  unsigned resize(unsigned);
};

#endif
