// Emacs -*- C++ -*-

//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

// $Log: compat.h,v $
// Revision 1.11  1994/10/03  19:49:31  thoth
// g++ std library has Complex, not complex.
// Symantec has problems with nested types in
// a function signature.
//
// Revision 1.10  1994/09/28  22:35:35  gmt
// Added define "NO_VOLATILE_FUNCTIONS"
//
// Revision 1.9  1994/09/27  19:41:09  fjsoria
// g++ v2.6 does not support non-inlined destructors
// added __NO_INLINE_DESTRUCTORS
//
// Revision 1.8  1994/09/27  01:39:49  gmt
// SC++ does not handle automatic autoinstantiation of static data, so
// define IA_NO_AUTOINST_OF_STATIC_DATA.
//
// Revision 1.7  1994/09/23  15:46:44  thoth
// Functions were in the library, but just weren't in the header files.
//
// Revision 1.6  1994/09/13  21:19:25  fjsoria
// added ansi compatibility for math.h for g++ v2.6
//
// Revision 1.5  1994/09/13  19:07:07  ljr
// changed to #define IA_NO_TEMPS_IN_CONDITIONAL_EXPRS for BC++
//
// Revision 1.4  1994/09/12  23:32:33  thoth
// screwy new symbol for g++ bug.
//
// Revision 1.3  1994/08/17  01:59:51  gmt
// Added log and id comments for RCS stuff.
//

// $Id: compat.h,v 1.11 1994/10/03 19:49:31 thoth Exp $

#ifndef IA_compat_h_
#define IA_compat_h_

/* first section.

   Based on what compiler you have, turn on/off various symbols to
control woejus hack workarounds.

*/

#ifdef __GNUC__

#define __NO_INLINE_DESTRUCTORS
#ifdef sun
// g++ still has a few problems

// bloody broken includes
extern "C" {
    double aint(double);
    int nint(double);
    double anint(double);
    int irint(double);

}

#endif // sun

#define IA_NO_AUTOINST_OF_STATIC_DATA
typedef Complex complex;	// gotta standardize on something.

#endif // __GNUC__

#ifdef __BCPLUSPLUS__
#define IA_NEED_TYPES
#define IA_NEED_AINT
#define IA_NEED_NINT
#define IA_NEED_ANINT
#define IA_NEED_RINT
#define IA_NEED_IRINT
#define IA_NO_TEMPS_IN_CONDITIONAL_EXPRS
#define IA_NO_VOLATILE_FUNCTIONS
#endif

#ifdef __SC__
#define IA_NEED_TYPES
#define IA_NEED_AINT
#define IA_NEED_NINT
#define IA_NEED_ANINT
#define IA_NEED_RINT
#define IA_NEED_IRINT
#define IA_NO_VOLATILE_FUNCTIONS

#define IA_NO_NESTED_ENUMS

#pragma template_access extern

#define IA_NO_AUTOINST_OF_STATIC_DATA

#endif // __SC__

/*
   Second section.

  Based on symbols defined in the compiler-dependent section above,
perform varios disgusting hacks to work around bustedness in various
compilers.

 */


#ifndef IA_NO_VOLATILE_FUNCTIONS
#define VOL_F
#else
#define VOL_F volatile
#endif

#ifdef IA_NEED_TYPES
typedef unsigned char u_char;
#else
#include <sys/types.h>
#endif

extern "C" {

#ifdef IA_NEED_AINT
double aint(double x);
#endif

#ifdef IA_NEED_NINT
int nint(double x);
#endif

#ifdef IA_NEED_ANINT
double anint(double x);
#endif

#ifdef IA_NEED_RINT
double rint(double x);
#endif

#ifdef IA_NEED_IRINT
int irint(double x);
#endif

}

#endif // IA_compat_h_
