//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: int-conv.desc,v $
// Revision 1.7  1994/02/24  18:25:47  thoth
// You can now convolve IntDDTemplates.
//
// Revision 1.6  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.5  1994/01/07  15:24:53  thoth
// Template reductions had wrong ring zeros.
//
// Revision 1.4  1993/11/17  18:41:07  thoth
// forward convolutions are now supported.
// template reductions are now supported.
//
// Revision 1.3  1993/09/27  15:54:56  thoth
// Make the xxxmax_product and xxxmin_product functions a little more robust.
//
// Revision 1.2  93/09/21  11:44:32  thoth
// remove cruft that belongs in double-convolutions.desc
// 
// Revision 1.1  93/09/15  13:04:31  thoth
// Initial revision
// 
// Revision 1.3  93/05/27  11:41:13  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:44:57  thoth
// New more descriptive names for standard convolutions.
// 
// Revision 1.1  93/03/18  11:23:20  thoth
// Initial revision
// 
// convolution linear_product T(int) T(int) T(int)
IA_DDTemplate<IA_Image<IA_Point<int>, int> > linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &img);

// convolution linear_product zero=0 I(int) I(int) T(int)
IA_Image<IA_Point<int>, int> linear_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> linear_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ) {
    return linear_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution linear_product zero=0 I(int) T(int) I(int)
IA_Image<IA_Point<int>, int> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img) {
    return linear_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

// we have to be careful doing the following transforms
// machine integers are NOT mathematical integers...
// convolution addmax_product zero=-MAXINT I(int) I(int) T(int)
IA_Image<IA_Point<int>, int> addmax_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> addmax_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ) {
    return addmax_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution addmax_product zero=-MAXINT I(int) T(int) I(int)
IA_Image<IA_Point<int>, int> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img) {
    return addmax_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution addmin_product zero=MAXINT I(int) I(int) T(int)
IA_Image<IA_Point<int>, int> addmin_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> addmin_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ) {
    return addmin_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution addmin_product zero=MAXINT I(int) T(int) I(int)
IA_Image<IA_Point<int>, int> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img) {
    return addmin_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution multmax_product zero=-1 I(int) I(int) T(int)
IA_Image<IA_Point<int>, int> multmax_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> multmax_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ) {
    return multmax_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution multmax_product zero=-1 I(int) T(int) I(int)
IA_Image<IA_Point<int>, int> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img) {
    return multmax_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution multmin_product zero=-1 I(int) I(int) T(int)
IA_Image<IA_Point<int>, int> multmin_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> multmin_product(const IA_CoreImage<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ) {
    return multmin_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution multmin_product zero=-1 I(int) T(int) I(int)
IA_Image<IA_Point<int>, int> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, int> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &templ,
		const IA_CoreImage<IA_Point<int>,int> &img) {
    return multmin_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
//
// reduction sum zero=0 I(int) T(int)
IA_Image<IA_Point<int>, int> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>, int> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction max zero=-MAXINT I(int) T(int)
IA_Image<IA_Point<int>, int> max(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>, int> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction min zero=MAXINT I(int) T(int)
IA_Image<IA_Point<int>, int> min(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>, int> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// binary operator+ zero=0 gamma=sum T(int) T(int) T(int)
IA_DDTemplate<IA_Image<IA_Point<int>, int> > operator+(
	const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &t1,
	const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &t2);

// binary min zero=MAXINT gamma=min T(int) T(int) T(int)
IA_DDTemplate<IA_Image<IA_Point<int>, int> > min(
	const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &t1,
	const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &t2);

// binary max zero=-MAXINT gamma=max T(int) T(int) T(int)
IA_DDTemplate<IA_Image<IA_Point<int>, int> > max(
	const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &t1,
	const IA_DDTemplate<IA_Image<IA_Point<int>, int> > &t2);

// convolution linear_product zero=0 gamma=sum circle=product T(int) T(int) T(int)
