// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ImgComp.c,v $
// Revision 1.1  1994/09/16  18:24:34  thoth
// Initial revision
//

#include "ImgComp.h"

template <class P, class Q, class R, class S, class T>
IA_CoreImage<P,Q> compose(R (*f)(S), const IA_CoreImage<P,T> &i, const Q*, const R*, const S*)
{
    IA_IVIter<P,T>	iter(i);
    const int size = i.card();
    Q * const vals = new Q[size];

    {
	Q	*scan=vals;
	T	temp;
	while (iter(temp))
	    *(scan++) = f(temp);
    }

    return IA_CoreImage<P,Q>(i.domain(), vals, size, 1);
}

template <class P, class Q, class R, class S, class T>
IA_CoreImage<P,Q> compose(const IA_Closure<S,R>&f,
			  const IA_CoreImage<P,T> &i,
			  const Q*)
{
    IA_IVIter<P,T>	iter(i);
    const int size = i.card();
    Q * const vals = new Q[size];

    {
	Q	*scan=vals;
	T	temp;
	while (iter(temp))
	    *(scan++) = f(temp);
    }

    return IA_CoreImage<P,Q>(i.domain(), vals, size, 1);
}
