// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: AuxImage.h,v $
// Revision 1.7  1994/09/16  14:57:59  thoth
// Compositions now live in their own include files.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/03/30  13:50:38  thoth
// zero_extension should be a template function.
//
// Revision 1.4  1994/03/14  15:48:33  thoth
// ValueSet has been replaced by container class Set.
//
// Revision 1.3  1994/02/26  16:01:09  thoth
// New 3-argument spatial composition functions.  Allow destination
// pointsets to be specified.
//
// Revision 1.2  1994/02/01  17:01:37  thoth
// Fix some screwy instantiation problems.
//
// Revision 1.1  1994/01/31  16:43:38  thoth
// Initial revision
//

#ifndef AuxImage_h_
#define AuxImage_h_

#include "Closure.h"
#include "Bit.h"
#include "Point.h"
#include "Set.h"

template <class P, class T> class IA_CoreImage;
template <class P, class T> class IA_Image;
template <class P,class T> class IA_VectorI;
template <class P,class T> class IA_IVIter;

template <class T>
void zero_extend_vec_scan(const IA_SetStructure &ss,
			  const T **src,
			  T **dest,
			  T zero)

template <class T>
void zero_extend_iter_scan(const IA_SetStructure &ss,
			   IA_IVIter<IA_Point<int>,T> *srciter,
			   T **dest,
			   T zero)

template <class P, class T>
void zero_extend(const IA_CoreImage<P,T> &, const IA_Set<P>&, T*, T);

template <class P, class T>
inline void zero_extend(const IA_Image<P,T> &img, const IA_Set<P> &ps,
			T *vals, T zero) {
    zero_extend((IA_CoreImage<P,T>&)img, ps, vals, zero);
}

//
//

template <class T> IA_CoreImage<IA_Point<int>,IA_Bit>
chi_contains(const IA_CoreImage<IA_Point<int>, T> &lhs,
	     const IA_Set<T> &rhs);

// the following two functions should not have to be declared here but
// CFront is busted
template <class T> IA_CoreImage<IA_Point<int>, int>
iter_chi_contains(const IA_CoreImage<IA_Point<int>, T> &lhs,
		  const IA_Set<T> &rhs);
template <class T> IA_CoreImage<IA_Point<int>, int>
vec_chi_contains(const IA_VectorI<IA_Point<int>, T> *lhs,
		 const IA_Set<T> &rhs)

//
//

template <class T> IA_CoreImage<IA_Point<int>,T>
transpose(const IA_CoreImage<IA_Point<int>, T> &);

// the following two functions should not have to be declared here but
// CFront is busted
template <class T> IA_CoreImage<IA_Point<int>, T>
vec_transpose(const IA_VectorI<IA_Point<int>, T> *img);

template <class T> IA_CoreImage<IA_Point<int>, T>
iter_transpose(const IA_CoreImage<IA_Point<int>, T> &img);

//
//

// spatial composition
template <class P, class T>
IA_CoreImage<P,T> compose
(const IA_CoreImage<P,T>&,
 const IA_Closure<P, P> &);

template <class P, class T>
IA_CoreImage<P,T> compose
(const IA_CoreImage<P,T>&,
 const IA_Closure<P, P> &,
 const IA_Set<P> &);

template <class P, class T>
IA_CoreImage<P,T> compose(const IA_CoreImage<P,T>&,
			  P (*)(const P&));

template <class P, class T>
IA_CoreImage<P,T> compose(const IA_CoreImage<P,T>&,
			  P (*)(const P&),
			  const IA_Set<P> &);

#include "ImgComp.h"

#endif // AuxImage_h_
