// semi-sphere-image.h Section: 5.7, The Rolling Ball Algorithm
//     Copyright 1994, Center for Computer Vision and Visualization,
//     University of Florida.  All rights reserved.

#ifndef _semi_sphere_image_h_
#define _semi_sphere_image_h_

#include "UcharDI.h"
#include "IntDI.h"
#include "FloatDI.h"


// This function produces the non-negative semi-spherical surface
//   of a sphere of dimension domain_dimension, and with the
//   indicated radius.
// Since the point type P is often IA_Point<int>, the domain
//   of the image will be a digital_disc() of the indicated radius.
// NOTE: parameters pzero and tzero are not used, but are necessary
//   because Cfront insists that the template parameters occur in
//   the signiture of the function, which does NOT include the
//   return type.  Use (P*)0 and (T*)0
//
template <class P, class T>
IA_Image<P,T>
semi_sphere_image( double radius, unsigned int domain_dimension,
		   P * pzero, T * tzero );

#endif
