// histogram.h     Section: 9.3 Histogram & 9.4 Cumulative Histogram
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//
// An iterative version of the histogram program.
// This version will usually be faster on sequential machines.
// The template version may be faster on parallel machines.


#ifndef _histogram_iter_h_
#define _histogram_iter_h_


#include "IntDI.h"
#include "UcharDI.h"
#include "FloatDI.h"


//////////////////////////////////////////////////////////////////
// histogram()
//   Calculate the histogram of an image using
//   iteration over the values of the image
//
template <class P, class T>
IA_Image<IA_Point<int>,int>
histogram( const IA_Image<P,T> & a );



//////////////////////////////////////////////////////////////////
// cumulative_histogram()
//   Calculate the cumulative histogram of an image using
//   iteration over the value of the histogram image
//
template <class P, class T>
IA_Image<IA_Point<int>,int>
cumulative_histogram( const IA_Image<P,T> & a );




//////////////////////////////////////////////////////////////////
// normalized_histogram()
//   Return the normalized histogram of an image
//
template <class P, class T>
IA_Image<IA_Point<int>,float>
normalized_histogram(const IA_Image<P,T> &a);


//////////////////////////////////////////////////////////////////
// normalized_cumulative_histogram()
//   Return the normalized cumulative histogram of an image
//
template <class P, class T>
IA_Image<IA_Point<int>,float>
normalized_cumulative_histogram(const IA_Image<P,T> &a);

#endif
