// find-max-points.h    Section: 10.3, Line Detection using the Hough Transform
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

#ifndef _find_max_points_h_
#define _find_max_points_h_

#include "Image.h"

// This routine may find a few more points than asked because
//    it extracts the max image value at each iteration, and
//    then adds all points associated with that value.
// Hence it is possible to get more than you ask for.

template <class P, class T>
IA_Set<P>
find_max_points( const IA_Image<P,T> & image,
		 unsigned int & how_many );

#endif
