// make-examplars.c

 
#include "make-examplars.h"


static int one[120] =  {0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,   
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0,
			0,0,0,0,1,1,0,0,0,0};


static int two[120] =  {1,1,1,1,1,1,1,1,1,1,
			1,1,1,1,1,1,1,1,1,1,
			1,1,0,0,0,0,0,0,1,1,
			0,0,0,0,0,0,0,1,1,1,
			0,0,0,0,0,0,1,1,1,0,
			0,0,0,0,0,1,1,0,0,0,  
			0,0,1,1,1,1,0,0,0,0,
			0,1,1,1,1,0,0,0,0,0,
			1,1,0,0,0,0,0,0,0,0,
			1,1,0,0,0,0,0,0,1,1,
			1,1,1,1,1,1,1,1,1,1,
			1,1,1,1,1,1,1,1,1,1};


static int three[120] ={0,1,1,1,1,1,1,1,0,0,
			0,1,1,1,1,1,1,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,1,1,1,0,0,
			0,0,0,0,0,1,1,1,0,0, 
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,1,1,1,1,1,1,1,1,0,
			0,1,1,1,1,1,1,1,0,0};


static int four[120] = {0,1,1,0,0,0,0,1,1,0,
			0,1,1,0,0,0,0,1,1,0,
			0,1,1,0,0,0,0,1,1,0,
			0,1,1,0,0,0,0,1,1,0,
			0,1,1,0,0,0,0,1,1,0,
			0,1,1,1,1,1,1,1,1,1,  
			0,1,1,1,1,1,1,1,1,1,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0};


static int nine[120]=  {0,1,1,1,1,1,1,1,1,0,
			0,1,1,1,1,1,1,1,1,0,
			0,1,1,0,0,0,0,1,1,0,
			0,1,1,0,0,0,0,1,1,0,
			0,1,1,0,0,0,0,1,1,0,
			0,1,1,1,1,1,1,1,1,0,  
			0,1,1,1,1,1,1,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0,
			0,0,0,0,0,0,0,1,1,0};


static int X[120] =     {1,1,0,0,0,0,0,0,1,1,
			 1,1,0,0,0,0,0,0,1,1,
			 0,1,1,0,0,0,0,1,1,0,
			 0,0,1,1,0,0,1,1,0,0,
			 0,0,1,1,0,0,1,1,0,0,
			 0,0,0,1,1,1,1,0,0,0,  
			 0,0,0,0,1,1,0,0,0,0,
			 0,0,0,1,1,1,1,0,0,0,
			 0,0,1,1,0,0,1,1,0,0,
			 0,1,1,0,0,0,0,1,1,0,
			 1,1,0,0,0,0,0,0,1,1,
			 1,1,0,0,0,0,0,0,1,1};


IA_Image<IA_Point<int>,int>
examplar_1() {
    return
	IA_Image<IA_Point<int>,int>(
	    IA_boxy_pset( IA_Point<int>(0), IA_Point<int>(119) ),
	    one, 120 );
}


IA_Image<IA_Point<int>,int>
examplar_2() {
    return
	IA_Image<IA_Point<int>,int>(
	    IA_boxy_pset( IA_Point<int>(0), IA_Point<int>(119) ),
	    two, 120 );
}


IA_Image<IA_Point<int>,int>
examplar_3() {
    return
	IA_Image<IA_Point<int>,int>(
	    IA_boxy_pset( IA_Point<int>(0), IA_Point<int>(119) ),
	    three, 120 );
}


IA_Image<IA_Point<int>,int>
examplar_4() {
    return
	IA_Image<IA_Point<int>,int>(
	    IA_boxy_pset( IA_Point<int>(0), IA_Point<int>(119) ),
	    four, 120 );
}


IA_Image<IA_Point<int>,int>
examplar_9() {
    return
	IA_Image<IA_Point<int>,int>(
	    IA_boxy_pset( IA_Point<int>(0), IA_Point<int>(119) ),
	    nine, 120 );
}


IA_Image<IA_Point<int>,int>
examplar_X() {
    return
	IA_Image<IA_Point<int>,int>(
	    IA_boxy_pset( IA_Point<int>(0), IA_Point<int>(119) ),
	    X, 120 );
}



void
write_examplars() {

    examplar_1().write_PGM( "examplar_1.pgm" );
    examplar_2().write_PGM( "examplar_2.pgm" );
    examplar_3().write_PGM( "examplar_3.pgm" );
    examplar_4().write_PGM( "examplar_4.pgm" );
    examplar_9().write_PGM( "examplar_9.pgm" );
    examplar_X().write_PGM( "examplar_X.pgm" );

}



/////////////////////////////////////////////////////////////////////////
// make_examplars_image()
// Create an 2D image from the array of 1D examplar images.
// We assume that each examplar image is the same cardinality.
//
IA_Image<IA_Point<int>,int>
make_examplars_image( IA_Image<IA_Point<int>,int> * e_array,
		      unsigned int e_array_size )
{
    // Remember the cardinality of each e_array image
    int e_card = e_array[0].domain().card();

    // Create the image we want to return
    IA_Image<IA_Point<int>,int>
	e_image( IA_boxy_pset( IA_Point<int>( 0, 0 ),
			       IA_Point<int>( e_array_size - 1,
					      e_card -1 ) ),
		 0 );

    // Map examplar image data into 2D e_im image data
    // We will declare the 1D and 2D points exactly once to avoid
    //    the overhead of re allocating them each time through a loop.
    IA_Point<int>
	p1d(0), // a 1D point
	p2d(0,0);

    for( int k=0; k<e_array_size; k++ ) {
	p2d[0] = k;
	for( int n=0; n<e_card; n++ ) {
	    p1d[0] = n;
	    p2d[1] = n;
	    e_image[ p2d ] = e_array[k]( p1d );
	}
    }

    // Return the new image
    return
	e_image;
}
