// median.c             Section: 2.8  Median Filter
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Image Algebra C++ implementation of a median filter,
//      utilizing neighborhood operations.
//

#include "median.h"
#include "median-gamma.h"


///////////////////////////////////////////////////////////////////
// median()
// Calculate the median filtered image for this image,
//    based on a user supplied neighborhood.

template <class P, class T>
IA_Image<P,T>
median( const IA_Image<P,T> & aImage,
	const IA_Neighborhood<P,P> & median_nbhd ) {

    // We will use a function that takes a array of values
    //   and returns the median of that array.
    // Now we can use the generalized neighborhood_reduction()
    //   with our "gamma()" function to calculate the result image.

    // Force correct choice of median_gamma() functions
    T (*f)(T*,unsigned);
    f = median_gamma;

    return
	neighborhood_reduction( aImage,
				median_nbhd,
				aImage.domain(),
				f );
}
