// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log: ListFPS.h,v $
// Revision 1.7  1994/10/04  18:14:39  thoth
// Prevent double-declaration in the defmap.
//
// Revision 1.6  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.5  1994/03/14  15:38:56  thoth
// ValueSet is no longer public to world.
//
// Revision 1.4  1993/11/17  18:02:03  thoth
// extensivep() is now extensive()
//
// Revision 1.3  1993/08/08  13:19:44  thoth
// added the iterator method.
// Data array can now be const (valueset is fixed)
//
// Revision 1.2  93/05/26  16:55:45  thoth
// Copyright Notices
// 
// Revision 1.1  93/05/10  08:33:56  thoth
// Initial revision
// 

#ifndef ListFPS_h_
#define ListFPS_h_

#include "BasePS.h"
#include "BaseSet.h"	// prevent double-declaration in ptrepository/defmap
#include "../valueset/ValueSet.h"

template <class P> class IA_ListPSIter;

template <class T>
class IA_ListPS: public IA_BasePS<T> {
    static char	dummy;

    IA_ValueSet<T>	points;
  public:
    IA_ListPS(const T &p)
    :IA_BasePS<T>(p.dim()), points(p) {}
    IA_ListPS(unsigned dim, const T *afp, unsigned count)
    :IA_BasePS<T>(dim), points(afp, count) {}

    int equal(IA_BasePS<T>*) const { return 0; }
    unsigned hash_self(unsigned) const { return 0; }

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }

    int contains(const T &p) const {
	return points.contains(p);
    }
    int extensive() const { return 1; }
    virtual IA_BasePSIter<T> *iterator() const;
    void output(ostream&o, unsigned=0) const {
	o << "List FPS\n" << points;
    }

    friend class IA_ListPSIter<T>;
};

#endif
