//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: uchar-conv.desc,v $
// Revision 1.5  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.4  1993/11/17  18:45:15  thoth
// forward convolutions are now supported.
// template reductions are now supported.
//
// Revision 1.3  1993/09/27  15:55:30  thoth
// Make the xxxmax_product and xxxmin_product functions a little more robust.
//
// Revision 1.2  1993/09/21  11:45:04  thoth
// Give uchar convolutions the proper names.
//
// Revision 1.1  93/09/15  13:05:15  thoth
// Initial revision
// 
// Revision 1.2  93/05/27  11:41:16  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/18  11:26:37  thoth
// Initial revision
// 
// convolution linear_product zero=0 I(u_char) I(u_char) T(u_char)
IA_Image<IA_Point<int>,u_char> linear_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> linear_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ) {
    return linear_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution linear_product zero=0 I(u_char) T(u_char) I(u_char)
IA_Image<IA_Point<int>,u_char> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img) {
    return linear_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

// we have to be careful doing the following transforms
// machine integers are NOT mathematical integers...
//the following is especially suspect.  What if there was NO
//intersection between the original image and the template.  We get the
//max value of the template, not the minimum value of the uchar ( 0 ).
//  *sigh*
// convolution addmax_product zero=0 I(u_char) I(u_char) T(u_char)
IA_Image<IA_Point<int>,u_char> addmax_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> addmax_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ) {
    return addmax_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution addmax_product zero=0 I(u_char) T(u_char) I(u_char)
IA_Image<IA_Point<int>,u_char> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img) {
    return addmax_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
// convolution addmin_product zero=255 I(u_char) I(u_char) T(u_char)
IA_Image<IA_Point<int>,u_char> addmin_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> addmin_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ) {
    return addmin_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution addmin_product zero=255 I(u_char) T(u_char) I(u_char)
IA_Image<IA_Point<int>,u_char> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img) {
    return addmin_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

// take advantage of the fact that we are doing integer arithmetic and
// probably have extra precision lying around.  If the ints on your
// machine are not twice the size of chars (almost impossible) then use
// a long for the temp variable
// convolution multmax_product zero=0 I(u_char) I(u_char) T(u_char)
IA_Image<IA_Point<int>,u_char> multmax_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> multmax_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ) {
    return multmax_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution multmax_product zero=0 I(u_char) T(u_char) I(u_char)
IA_Image<IA_Point<int>,u_char> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img) {
    return multmax_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

// what do we do when the template has a zero and the image is
// undefined?  Currently we multiply +infty (255) by zero and get 0, a
// minimum value.  crap.
// convolution multmin_product zero=255 I(u_char) I(u_char) T(u_char)
IA_Image<IA_Point<int>,u_char> multmin_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> multmin_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ) {
    return multmin_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution multmin_product zero=255 I(u_char) T(u_char) I(u_char)
IA_Image<IA_Point<int>,u_char> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,u_char> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img) {
    return multmin_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

//
//
// reduction sum zero=0 I(int) T(u_char)
IA_Image<IA_Point<int>,int> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction max zero=0 I(u_char) T(u_char)
IA_Image<IA_Point<int>,u_char> max(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction min zero=255 I(u_char) T(u_char)
IA_Image<IA_Point<int>,u_char> min(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > templ,
	IA_Set<IA_Point<int> > dest_domain);

