// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: uchar-operations.desc,v $
//  Revision 1.9.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.9.1.1  1994/12/28  17:23:06  thoth
//  scalar-image operations accept u_char instead of int now.

//  Revision 1.9  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.8  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Revision 1.7  1994/02/03  16:22:48  thoth
//  Arguments to binary operations were specified "lhs rhs return" but are
//  now specified "return lhs rhs" to be consistent with function declaration
//  syntax.

//  Revision 1.6  1994/01/31  16:06:03  thoth
//  some extra constructors and the new conversions.
//  chi functions now return BitDIs.

//  Revision 1.5  1993/12/29  17:28:38  thoth
//  reductions require a zero now.

//  Revision 1.4  1993/11/17  18:45:41  thoth
//  we now have the product reduction and a sqr that returns an IntDI.

//  Revision 1.3  1993/10/05  19:34:57  thoth
//  binary max and min available. are now

//  Revision 1.2  1993/09/21  11:46:07  thoth
//  pointwise operations now named "chi" instead of "pwise".

//  Revision 1.1  93/09/15  13:05:29  thoth
//  Initial revision
//  
//  Revision 1.3  93/05/27  11:41:17  thoth
//  Copyright Notices
//  
//  Revision 1.2  93/05/18  21:45:40  thoth
//  New reductions to bring ucharDI up to speed.
//  
//  Revision 1.1  93/03/18  11:25:21  thoth
//  Initial revision
//  
#include "UcharDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
#define const_reduce_int_u_char_sum
inline int const_reduce_sum(unsigned sz, u_char arg)
{
    return sz * arg;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction sum subop=operator+ zero=0 int I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_op_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:43  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:05:07  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

#ifndef REDUCE_int_u_char_sum
#define REDUCE_int_u_char_sum
IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_int_u_char_sum_tbl;

void IA_fill_Image_IP_int_u_char_sum_tbl();
#endif // REDUCE_int_u_char_sum


int sum ( const IA_Image<IA_Point<int>, u_char> &arg)
{
    if (!IA_Image_IP_int_u_char_sum_tbl)
	IA_fill_Image_IP_int_u_char_sum_tbl();

    int(*f)
	(IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_int_u_char_sum_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, u_char>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_int_u_char_sum
#define vec_reduce_int_u_char_sum
static int
vec_reduce_sum(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_VectorI<IA_Point<int>, u_char> *lhs =
	(IA_VectorI<IA_Point<int>, u_char> *) &lhs_;

    const u_char *ls = lhs->vec;

    int	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = rval + (*(ls++));
    }

    return rval;
}
#endif // vec_reduce_int_u_char_sum

#ifndef scalar_reduce_int_u_char_sum
#define scalar_reduce_int_u_char_sum
static int
scalar_reduce_sum(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_ConstI<IA_Point<int>, u_char> *lhs =
	(IA_ConstI<IA_Point<int>, u_char> *) &lhs_;

    int	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = rval + lhs->value;

    return rval;
}
#endif // scalar_reduce_int_u_char_sum

// scalar-scalar operation is trivial

#ifndef iter_reduce_int_u_char_sum
#define iter_reduce_int_u_char_sum
static int
iter_reduce_sum(IA_BaseImage<IA_Point<int>, u_char> &lhs)
{
    const unsigned sz = lhs.domain().card();

    u_char ltmp;
    IA_BaseIVIter<IA_Point<int>, u_char>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    int	rval=ltmp;

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = rval + ltmp;
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_int_u_char_sum

#ifndef FILL_REDUCE_int_u_char_sum
#define FILL_REDUCE_int_u_char_sum
void IA_fill_Image_IP_int_u_char_sum_tbl()
{
    if (IA_Image_IP_int_u_char_sum_tbl)
	return;

    IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_reduce_sum;

    IA_Image_IP_int_u_char_sum_tbl = new IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_reduce_sum);
    IA_Image_IP_int_u_char_sum_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_reduce_sum);
    IA_Image_IP_int_u_char_sum_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_reduce_sum);

}
#endif // REDUCE_int_u_char_sum

#if 0

static int vec_reduce_sum(const IA_VectorI<IA_Point<int>, u_char> *arg)
{
    const u_char *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) +  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_u_char_sum
#define const_reduce_int_u_char_sum
static int const_reduce_sum(unsigned sz, u_char arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) + arg);
    }
    return rval;
}
#endif

static int iter_reduce_sum(const IA_Image<IA_Point<int>, u_char> &arg)
{
    IA_IVIter<IA_Point<int>, u_char>	iter(arg);

    u_char	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) +  temp);
    }

    return rval;
}

int sum ( const IA_Image<IA_Point<int>, u_char> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 0 );
    IA_Image<IA_Point<int>, u_char>	arg(arg_);

    IA_BaseImage<IA_Point<int>, u_char>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, u_char>::s_type()) {
	return vec_reduce_sum((IA_VectorI<IA_Point<int>, u_char> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, u_char>::s_type()) {
	return const_reduce_sum
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, u_char> *)bip)->value);
    } else {
	return iter_reduce_sum(arg);
    }
}

#endif

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction product subop=operator* zero=1 int I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_op_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:43  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:05:07  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

#ifndef REDUCE_int_u_char_product
#define REDUCE_int_u_char_product
IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_int_u_char_product_tbl;

void IA_fill_Image_IP_int_u_char_product_tbl();
#endif // REDUCE_int_u_char_product


int product ( const IA_Image<IA_Point<int>, u_char> &arg)
{
    if (!IA_Image_IP_int_u_char_product_tbl)
	IA_fill_Image_IP_int_u_char_product_tbl();

    int(*f)
	(IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_int_u_char_product_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, u_char>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_int_u_char_product
#define vec_reduce_int_u_char_product
static int
vec_reduce_product(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_VectorI<IA_Point<int>, u_char> *lhs =
	(IA_VectorI<IA_Point<int>, u_char> *) &lhs_;

    const u_char *ls = lhs->vec;

    int	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = rval * (*(ls++));
    }

    return rval;
}
#endif // vec_reduce_int_u_char_product

#ifndef scalar_reduce_int_u_char_product
#define scalar_reduce_int_u_char_product
static int
scalar_reduce_product(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_ConstI<IA_Point<int>, u_char> *lhs =
	(IA_ConstI<IA_Point<int>, u_char> *) &lhs_;

    int	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = rval * lhs->value;

    return rval;
}
#endif // scalar_reduce_int_u_char_product

// scalar-scalar operation is trivial

#ifndef iter_reduce_int_u_char_product
#define iter_reduce_int_u_char_product
static int
iter_reduce_product(IA_BaseImage<IA_Point<int>, u_char> &lhs)
{
    const unsigned sz = lhs.domain().card();

    u_char ltmp;
    IA_BaseIVIter<IA_Point<int>, u_char>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    int	rval=ltmp;

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = rval * ltmp;
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_int_u_char_product

#ifndef FILL_REDUCE_int_u_char_product
#define FILL_REDUCE_int_u_char_product
void IA_fill_Image_IP_int_u_char_product_tbl()
{
    if (IA_Image_IP_int_u_char_product_tbl)
	return;

    IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_reduce_product;

    IA_Image_IP_int_u_char_product_tbl = new IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_reduce_product);
    IA_Image_IP_int_u_char_product_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_reduce_product);
    IA_Image_IP_int_u_char_product_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_reduce_product);

}
#endif // REDUCE_int_u_char_product

#if 0

static int vec_reduce_product(const IA_VectorI<IA_Point<int>, u_char> *arg)
{
    const u_char *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) *  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_u_char_product
#define const_reduce_int_u_char_product
static int const_reduce_product(unsigned sz, u_char arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) * arg);
    }
    return rval;
}
#endif

static int iter_reduce_product(const IA_Image<IA_Point<int>, u_char> &arg)
{
    IA_IVIter<IA_Point<int>, u_char>	iter(arg);

    u_char	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) *  temp);
    }

    return rval;
}

int product ( const IA_Image<IA_Point<int>, u_char> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 1 );
    IA_Image<IA_Point<int>, u_char>	arg(arg_);

    IA_BaseImage<IA_Point<int>, u_char>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, u_char>::s_type()) {
	return vec_reduce_product((IA_VectorI<IA_Point<int>, u_char> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, u_char>::s_type()) {
	return const_reduce_product
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, u_char> *)bip)->value);
    } else {
	return iter_reduce_product(arg);
    }
}

#endif

inline int max(u_char a, int b)
{
    return (a<b)?b:a;
}
#define const_reduce_u_char_u_char_max
inline u_char const_reduce_max(unsigned , u_char arg)
{
    return arg;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction max subop=max zero=0 u_char I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_fn_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:04:51  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

#ifndef REDUCE_u_char_u_char_max
#define REDUCE_u_char_u_char_max
IA_UnaryOperationsTable<u_char,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_u_char_u_char_max_tbl;

void IA_fill_Image_IP_u_char_u_char_max_tbl();
#endif // REDUCE_u_char_u_char_max


u_char max ( const IA_Image<IA_Point<int>, u_char> &arg)
{
    if (!IA_Image_IP_u_char_u_char_max_tbl)
	IA_fill_Image_IP_u_char_u_char_max_tbl();

    u_char(*f)
	(IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_u_char_u_char_max_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, u_char>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_u_char_u_char_max
#define vec_reduce_u_char_u_char_max
static u_char
vec_reduce_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_VectorI<IA_Point<int>, u_char> *lhs =
	(IA_VectorI<IA_Point<int>, u_char> *) &lhs_;

    const u_char *ls = lhs->vec;

    u_char	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}
#endif // vec_reduce_u_char_u_char_max

#ifndef scalar_reduce_u_char_u_char_max
#define scalar_reduce_u_char_u_char_max
static u_char
scalar_reduce_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_ConstI<IA_Point<int>, u_char> *lhs =
	(IA_ConstI<IA_Point<int>, u_char> *) &lhs_;

    u_char	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = max( rval, lhs->value );

    return rval;
}
#endif // scalar_reduce_u_char_u_char_max

// scalar-scalar operation is trivial

#ifndef iter_reduce_u_char_u_char_max
#define iter_reduce_u_char_u_char_max
static u_char
iter_reduce_max(IA_BaseImage<IA_Point<int>, u_char> &lhs)
{
    const unsigned sz = lhs.domain().card();

    u_char ltmp;
    IA_BaseIVIter<IA_Point<int>, u_char>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    u_char	rval=ltmp;
    

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = max(rval, ltmp);
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_u_char_u_char_max

#ifndef FILL_REDUCE_u_char_u_char_max
#define FILL_REDUCE_u_char_u_char_max
void IA_fill_Image_IP_u_char_u_char_max_tbl()
{
    if (IA_Image_IP_u_char_u_char_max_tbl)
	return;

    IA_UnaryOperationsTable<u_char,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_reduce_max;

    IA_Image_IP_u_char_u_char_max_tbl = new IA_UnaryOperationsTable<u_char,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_reduce_max);
    IA_Image_IP_u_char_u_char_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_reduce_max);
    IA_Image_IP_u_char_u_char_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_reduce_max);

}
#endif // REDUCE_u_char_u_char_max

#if 0

static u_char vec_reduce_max(const IA_VectorI<IA_Point<int>, u_char> *arg)
{
    const u_char *ls = arg->vec;

    u_char	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_u_char_u_char_max
#define const_reduce_u_char_u_char_max
static u_char const_reduce_max(unsigned sz, u_char arg)
{
    u_char	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = max(rval, arg);
    }
    return rval;
}
#endif

static u_char iter_reduce_max(const IA_Image<IA_Point<int>, u_char> &arg)
{
    IA_IVIter<IA_Point<int>, u_char>	iter(arg);

    u_char	temp;
    iter(temp);

    u_char	rval=temp;

    while(iter(temp)) {
	rval = max(rval, temp);
    }

    return rval;
}

u_char max ( const IA_Image<IA_Point<int>, u_char> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 0 );
    IA_Image<IA_Point<int>, u_char>	arg(arg_);

    IA_BaseImage<IA_Point<int>, u_char>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, u_char>::s_type()) {
	return vec_reduce_max((IA_VectorI<IA_Point<int>, u_char> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, u_char>::s_type()) {
	return const_reduce_max
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, u_char> *)bip)->value);
    } else {
	return iter_reduce_max(arg);
    }
}
#endif

inline int min(u_char a, int b)
{
    return (a<b)?a:b;
}
#define const_reduce_u_char_u_char_min
inline u_char const_reduce_min(unsigned , u_char arg)
{
    return arg;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction min subop=min zero=255 u_char I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_fn_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:04:51  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

#ifndef REDUCE_u_char_u_char_min
#define REDUCE_u_char_u_char_min
IA_UnaryOperationsTable<u_char,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_u_char_u_char_min_tbl;

void IA_fill_Image_IP_u_char_u_char_min_tbl();
#endif // REDUCE_u_char_u_char_min


u_char min ( const IA_Image<IA_Point<int>, u_char> &arg)
{
    if (!IA_Image_IP_u_char_u_char_min_tbl)
	IA_fill_Image_IP_u_char_u_char_min_tbl();

    u_char(*f)
	(IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_u_char_u_char_min_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, u_char>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_u_char_u_char_min
#define vec_reduce_u_char_u_char_min
static u_char
vec_reduce_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_VectorI<IA_Point<int>, u_char> *lhs =
	(IA_VectorI<IA_Point<int>, u_char> *) &lhs_;

    const u_char *ls = lhs->vec;

    u_char	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}
#endif // vec_reduce_u_char_u_char_min

#ifndef scalar_reduce_u_char_u_char_min
#define scalar_reduce_u_char_u_char_min
static u_char
scalar_reduce_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_)
{
    const IA_ConstI<IA_Point<int>, u_char> *lhs =
	(IA_ConstI<IA_Point<int>, u_char> *) &lhs_;

    u_char	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = min( rval, lhs->value );

    return rval;
}
#endif // scalar_reduce_u_char_u_char_min

// scalar-scalar operation is trivial

#ifndef iter_reduce_u_char_u_char_min
#define iter_reduce_u_char_u_char_min
static u_char
iter_reduce_min(IA_BaseImage<IA_Point<int>, u_char> &lhs)
{
    const unsigned sz = lhs.domain().card();

    u_char ltmp;
    IA_BaseIVIter<IA_Point<int>, u_char>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    u_char	rval=ltmp;
    

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = min(rval, ltmp);
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_u_char_u_char_min

#ifndef FILL_REDUCE_u_char_u_char_min
#define FILL_REDUCE_u_char_u_char_min
void IA_fill_Image_IP_u_char_u_char_min_tbl()
{
    if (IA_Image_IP_u_char_u_char_min_tbl)
	return;

    IA_UnaryOperationsTable<u_char,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_reduce_min;

    IA_Image_IP_u_char_u_char_min_tbl = new IA_UnaryOperationsTable<u_char,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_reduce_min);
    IA_Image_IP_u_char_u_char_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_reduce_min);
    IA_Image_IP_u_char_u_char_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_reduce_min);

}
#endif // REDUCE_u_char_u_char_min

#if 0

static u_char vec_reduce_min(const IA_VectorI<IA_Point<int>, u_char> *arg)
{
    const u_char *ls = arg->vec;

    u_char	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_u_char_u_char_min
#define const_reduce_u_char_u_char_min
static u_char const_reduce_min(unsigned sz, u_char arg)
{
    u_char	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = min(rval, arg);
    }
    return rval;
}
#endif

static u_char iter_reduce_min(const IA_Image<IA_Point<int>, u_char> &arg)
{
    IA_IVIter<IA_Point<int>, u_char>	iter(arg);

    u_char	temp;
    iter(temp);

    u_char	rval=temp;

    while(iter(temp)) {
	rval = min(rval, temp);
    }

    return rval;
}

u_char min ( const IA_Image<IA_Point<int>, u_char> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 255 );
    IA_Image<IA_Point<int>, u_char>	arg(arg_);

    IA_BaseImage<IA_Point<int>, u_char>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,u_char,u_char,u_char>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, u_char>::s_type()) {
	return vec_reduce_min((IA_VectorI<IA_Point<int>, u_char> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, u_char>::s_type()) {
	return const_reduce_min
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, u_char> *)bip)->value);
    } else {
	return iter_reduce_min(arg);
    }
}
#endif

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename UIO-unaries.c
//
