// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: uchar-operations.desc,v $
//  Revision 1.9.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.9.1.1  1994/12/28  17:23:06  thoth
//  scalar-image operations accept u_char instead of int now.

//  Revision 1.9  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.8  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Revision 1.7  1994/02/03  16:22:48  thoth
//  Arguments to binary operations were specified "lhs rhs return" but are
//  now specified "return lhs rhs" to be consistent with function declaration
//  syntax.

//  Revision 1.6  1994/01/31  16:06:03  thoth
//  some extra constructors and the new conversions.
//  chi functions now return BitDIs.

//  Revision 1.5  1993/12/29  17:28:38  thoth
//  reductions require a zero now.

//  Revision 1.4  1993/11/17  18:45:41  thoth
//  we now have the product reduction and a sqr that returns an IntDI.

//  Revision 1.3  1993/10/05  19:34:57  thoth
//  binary max and min available. are now

//  Revision 1.2  1993/09/21  11:46:07  thoth
//  pointwise operations now named "chi" instead of "pwise".

//  Revision 1.1  93/09/15  13:05:29  thoth
//  Initial revision
//  
//  Revision 1.3  93/05/27  11:41:17  thoth
//  Copyright Notices
//  
//  Revision 1.2  93/05/18  21:45:40  thoth
//  New reductions to bring ucharDI up to speed.
//  
//  Revision 1.1  93/03/18  11:25:21  thoth
//  Initial revision
//  
#include "UcharDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
template <class T>
inline T max(T a, T b)
{
    return (a<b)?b:a;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(u_char) I(u_char) I(u_char)
//
#ifndef BOT_u_char_u_char_u_char_max
#define BOT_u_char_u_char_u_char_max
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_u_char_u_char_u_char_max_tbl;

void IA_fill_Image_IP_u_char_u_char_u_char_max_tbl();

#endif // BOT_u_char_u_char_u_char_max
IA_Image<IA_Point<int>, u_char>
max ( const IA_Image<IA_Point<int>, u_char> &lhs,
		const IA_Image<IA_Point<int>, u_char> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, u_char>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_u_char_u_char_u_char_max_tbl)
	IA_fill_Image_IP_u_char_u_char_u_char_max_tbl();

    IA_BaseImage<IA_Point<int>, u_char>*(*f)( IA_BaseImage<IA_Point<int>, u_char> &,
		IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_u_char_u_char_u_char_max_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,u_char>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,u_char>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,u_char>
	(IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, u_char> *
vec_vec_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, u_char> *rhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&rhs_;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*ls, *rs);
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_max
#define vec_scalar_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
vec_scalar_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_max

static IA_BaseImage<IA_Point<int>, u_char> *
vec_iter_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = max(*ls, rtmp);
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_max
#define scalar_vec_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_vec_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return vec_scalar_bo_max(rhs_, lhs_);
}
#endif // scalar_vec_u_char_u_char_u_char_max

#ifndef scalar_scalar_u_char_u_char_u_char_max
#define scalar_scalar_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_scalar_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
    u_char	aval = max( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, u_char>(domain, aval);
}
#endif // scalar_scalar_u_char_u_char_u_char_max

#ifndef scalar_iter_u_char_u_char_u_char_max
#define scalar_iter_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_iter_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = max(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_max

static IA_BaseImage<IA_Point<int>, u_char> *
iter_vec_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return vec_iter_bo_max(rhs_, lhs_);
}

#ifndef iter_scalar_u_char_u_char_u_char_max
#define iter_scalar_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
iter_scalar_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return scalar_iter_bo_max(rhs_, lhs_);
}
#endif // iter_scalar_u_char_u_char_u_char_max

static IA_BaseImage<IA_Point<int>, u_char> *
iter_iter_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*liter = lhs_.value_iterator();
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = max(ltmp, rtmp);
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_u_char_u_char_u_char_max
#define FILL_BOT_u_char_u_char_u_char_max
void IA_fill_Image_IP_u_char_u_char_u_char_max_tbl()
{
    if (IA_Image_IP_u_char_u_char_u_char_max_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_iter_bo_max;

    IA_Image_IP_u_char_u_char_u_char_max_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_iter_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_vec_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 vec_scalar_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 0,
	 vec_iter_bo_max);

    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 scalar_vec_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_scalar_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 0,
	 scalar_iter_bo_max);

    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 iter_vec_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 iter_scalar_bo_max);

}
#endif // BOT_u_char_u_char_u_char_max

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(u_char) I(u_char) u_char
//
#ifndef BOT_u_char_u_char_u_char_max
#define BOT_u_char_u_char_u_char_max
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_u_char_u_char_u_char_max_tbl;

void IA_fill_Image_IP_u_char_u_char_u_char_max_tbl();

#endif // BOT_u_char_u_char_u_char_max
IA_Image<IA_Point<int>, u_char>
max ( const IA_Image<IA_Point<int>, u_char> &lhs,
		u_char rhs)
{
    if (!IA_Image_IP_u_char_u_char_u_char_max_tbl)
	IA_fill_Image_IP_u_char_u_char_u_char_max_tbl();

    IA_BaseImage<IA_Point<int>, u_char>*(*f)( IA_BaseImage<IA_Point<int>, u_char> &,
		IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_u_char_u_char_u_char_max_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, u_char>::s_type());
    IA_BaseImage<IA_Point<int>,u_char>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,u_char>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,u_char>
	(IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_u_char_u_char_u_char_max
#define vec_scalar_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
vec_scalar_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_max

#ifndef scalar_scalar_u_char_u_char_u_char_max
#define scalar_scalar_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_scalar_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
    u_char	aval = max( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, u_char>(domain, aval);
}
#endif // scalar_scalar_u_char_u_char_u_char_max

#ifndef scalar_iter_u_char_u_char_u_char_max
#define scalar_iter_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_iter_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = max(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_max

#ifndef iter_scalar_u_char_u_char_u_char_max
#define iter_scalar_u_char_u_char_u_char_max
static IA_BaseImage<IA_Point<int>, u_char> *
iter_scalar_bo_max(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return scalar_iter_bo_max(rhs_, lhs_);
}
#endif // iter_scalar_u_char_u_char_u_char_max

#ifndef FILL_BOT_u_char_u_char_u_char_max
#define FILL_BOT_u_char_u_char_u_char_max
void IA_fill_Image_IP_u_char_u_char_u_char_max_tbl()
{
    if (IA_Image_IP_u_char_u_char_u_char_max_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_iter_bo_max;

    IA_Image_IP_u_char_u_char_u_char_max_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_iter_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_vec_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 vec_scalar_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 0,
	 vec_iter_bo_max);

    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 scalar_vec_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_scalar_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 0,
	 scalar_iter_bo_max);

    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 iter_vec_bo_max);
    IA_Image_IP_u_char_u_char_u_char_max_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 iter_scalar_bo_max);

}
#endif // BOT_u_char_u_char_u_char_max

template <class T>
inline T min(T a, T b)
{
    return (a<b)?a:b;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(u_char) I(u_char) I(u_char)
//
#ifndef BOT_u_char_u_char_u_char_min
#define BOT_u_char_u_char_u_char_min
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_u_char_u_char_u_char_min_tbl;

void IA_fill_Image_IP_u_char_u_char_u_char_min_tbl();

#endif // BOT_u_char_u_char_u_char_min
IA_Image<IA_Point<int>, u_char>
min ( const IA_Image<IA_Point<int>, u_char> &lhs,
		const IA_Image<IA_Point<int>, u_char> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, u_char>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_u_char_u_char_u_char_min_tbl)
	IA_fill_Image_IP_u_char_u_char_u_char_min_tbl();

    IA_BaseImage<IA_Point<int>, u_char>*(*f)( IA_BaseImage<IA_Point<int>, u_char> &,
		IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_u_char_u_char_u_char_min_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,u_char>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,u_char>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,u_char>
	(IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, u_char> *
vec_vec_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, u_char> *rhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&rhs_;
	const u_char *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*ls, *rs);
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}

#ifndef vec_scalar_u_char_u_char_u_char_min
#define vec_scalar_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
vec_scalar_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_min

static IA_BaseImage<IA_Point<int>, u_char> *
vec_iter_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = min(*ls, rtmp);
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}

#ifndef scalar_vec_u_char_u_char_u_char_min
#define scalar_vec_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_vec_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return vec_scalar_bo_min(rhs_, lhs_);
}
#endif // scalar_vec_u_char_u_char_u_char_min

#ifndef scalar_scalar_u_char_u_char_u_char_min
#define scalar_scalar_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_scalar_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
    u_char	aval = min( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, u_char>(domain, aval);
}
#endif // scalar_scalar_u_char_u_char_u_char_min

#ifndef scalar_iter_u_char_u_char_u_char_min
#define scalar_iter_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_iter_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = min(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_min

static IA_BaseImage<IA_Point<int>, u_char> *
iter_vec_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return vec_iter_bo_min(rhs_, lhs_);
}

#ifndef iter_scalar_u_char_u_char_u_char_min
#define iter_scalar_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
iter_scalar_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return scalar_iter_bo_min(rhs_, lhs_);
}
#endif // iter_scalar_u_char_u_char_u_char_min

static IA_BaseImage<IA_Point<int>, u_char> *
iter_iter_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	u_char ltmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*liter = lhs_.value_iterator();
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = min(ltmp, rtmp);
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_u_char_u_char_u_char_min
#define FILL_BOT_u_char_u_char_u_char_min
void IA_fill_Image_IP_u_char_u_char_u_char_min_tbl()
{
    if (IA_Image_IP_u_char_u_char_u_char_min_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_iter_bo_min;

    IA_Image_IP_u_char_u_char_u_char_min_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_iter_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_vec_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 vec_scalar_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 0,
	 vec_iter_bo_min);

    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 scalar_vec_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_scalar_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 0,
	 scalar_iter_bo_min);

    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 iter_vec_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 iter_scalar_bo_min);

}
#endif // BOT_u_char_u_char_u_char_min

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(u_char) I(u_char) u_char
//
#ifndef BOT_u_char_u_char_u_char_min
#define BOT_u_char_u_char_u_char_min
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >
	*IA_Image_IP_u_char_u_char_u_char_min_tbl;

void IA_fill_Image_IP_u_char_u_char_u_char_min_tbl();

#endif // BOT_u_char_u_char_u_char_min
IA_Image<IA_Point<int>, u_char>
min ( const IA_Image<IA_Point<int>, u_char> &lhs,
		u_char rhs)
{
    if (!IA_Image_IP_u_char_u_char_u_char_min_tbl)
	IA_fill_Image_IP_u_char_u_char_u_char_min_tbl();

    IA_BaseImage<IA_Point<int>, u_char>*(*f)( IA_BaseImage<IA_Point<int>, u_char> &,
		IA_BaseImage<IA_Point<int>, u_char> &);
    f = IA_Image_IP_u_char_u_char_u_char_min_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, u_char>::s_type());
    IA_BaseImage<IA_Point<int>,u_char>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,u_char>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,u_char>
	(IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_u_char_u_char_u_char_min
#define vec_scalar_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
vec_scalar_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_VectorI<IA_Point<int>, u_char> *lhs
		= (IA_VectorI<IA_Point<int>, u_char> *)&lhs_;
	const u_char *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*ls, rhs->value);
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_u_char_u_char_min

#ifndef scalar_scalar_u_char_u_char_u_char_min
#define scalar_scalar_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_scalar_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	IA_ConstI<IA_Point<int>, u_char> *rhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&rhs_;
    u_char	aval = min( lhs->value, rhs->value );
    return new IA_ConstI<IA_Point<int>, u_char>(domain, aval);
}
#endif // scalar_scalar_u_char_u_char_u_char_min

#ifndef scalar_iter_u_char_u_char_u_char_min
#define scalar_iter_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
scalar_iter_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_ConstI<IA_Point<int>, u_char> *lhs
		= (IA_ConstI<IA_Point<int>, u_char> *)&lhs_;
	u_char rtmp;
	IA_BaseIVIter<IA_Point<int>, u_char>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = min(lhs->value, rtmp);
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // scalar_iter_u_char_u_char_u_char_min

#ifndef iter_scalar_u_char_u_char_u_char_min
#define iter_scalar_u_char_u_char_u_char_min
static IA_BaseImage<IA_Point<int>, u_char> *
iter_scalar_bo_min(IA_BaseImage<IA_Point<int>, u_char> &lhs_,
	IA_BaseImage<IA_Point<int>, u_char> &rhs_)
{
    return scalar_iter_bo_min(rhs_, lhs_);
}
#endif // iter_scalar_u_char_u_char_u_char_min

#ifndef FILL_BOT_u_char_u_char_u_char_min
#define FILL_BOT_u_char_u_char_u_char_min
void IA_fill_Image_IP_u_char_u_char_u_char_min_tbl()
{
    if (IA_Image_IP_u_char_u_char_u_char_min_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >::function f;
    f = iter_iter_bo_min;

    IA_Image_IP_u_char_u_char_u_char_min_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, u_char>,
	IA_BaseImage<IA_Point<int>, u_char> >(iter_iter_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 vec_vec_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 vec_scalar_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 0,
	 vec_iter_bo_min);

    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 scalar_vec_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 scalar_scalar_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 0,
	 scalar_iter_bo_min);

    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, u_char>::s_type(),
	 iter_vec_bo_min);
    IA_Image_IP_u_char_u_char_u_char_min_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, u_char>::s_type(),
	 iter_scalar_bo_min);

}
#endif // BOT_u_char_u_char_u_char_min

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename UIO-reductions.c
//
