// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1994, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: rgb-operations.desc,v $
//  Revision 1.3.1.1  1994/12/28  18:20:26  thoth
//  Image operations are now friendly with FBI
//  Image ops now use operations table instead of switch.

//  Revision 1.3  1994/08/22  15:20:29  thoth
//  DOS-inspired name rework.

//  Revision 1.2  1994/05/17  12:58:54  thoth
//  modifications to work with new operations generation scheme.

//  RGB operations for the RGB Discrete Image
#include "FBI.h"
#include "../valueset/OpTable.h"
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// constructor I(IA_RGB) I(IA_Bit)
//
//** constructors are obsolete?

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// constructor I(IA_RGB) I(u_char)
//
//** constructors are obsolete?


//  Need to be able to construct an RGB from three u_chars

// constructor I(IA_RGB) I(u_char) I(u_char) I(u_char)
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise to_int I(int) I(IA_RGB)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_int_IA_RGB_to_int
#define UOT_int_IA_RGB_to_int
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_int_IA_RGB_to_int_tbl;

void IA_fill_Image_IP_int_IA_RGB_to_int_tbl();
#endif


IA_Image<IA_Point<int>, int>
to_int ( const IA_Image<IA_Point<int>, IA_RGB> &arg)
{
    if (!IA_Image_IP_int_IA_RGB_to_int_tbl)
	IA_fill_Image_IP_int_IA_RGB_to_int_tbl();

    IA_BaseImage<IA_Point<int>, int>*(*f)
	(IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_int_IA_RGB_to_int_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, IA_RGB>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, int,int,int>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_int_IA_RGB_to_int
#define vec_uop_int_IA_RGB_to_int
static IA_BaseImage<IA_Point<int>, int>*
vec_uo_to_int(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_VectorI<IA_Point<int>, IA_RGB> *lhs =
	(IA_VectorI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const IA_RGB *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = to_int(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // vec_uop_int_IA_RGB_to_int

#ifndef scalar_uop_int_IA_RGB_to_int
#define scalar_uop_int_IA_RGB_to_int
static IA_BaseImage<IA_Point<int>, int>*
scalar_uo_to_int(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_ConstI<IA_Point<int>, IA_RGB> *lhs =
	(IA_ConstI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, int>(domain, to_int(lhs->value));
}
#endif // scalar_uop_int_IA_RGB_to_int

// scalar-scalar operation is trivial

#ifndef iter_uop_int_IA_RGB_to_int
#define iter_uop_int_IA_RGB_to_int
static IA_BaseImage<IA_Point<int>, int>*
iter_uo_to_int(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = to_int(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, int>(domain, vec, sz, 1);
}
#endif // iter_uop_int_IA_RGB_to_int

#ifndef FILL_UOT_int_IA_RGB_to_int
#define FILL_UOT_int_IA_RGB_to_int
void IA_fill_Image_IP_int_IA_RGB_to_int_tbl()
{
    if (IA_Image_IP_int_IA_RGB_to_int_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_uo_to_int;

    IA_Image_IP_int_IA_RGB_to_int_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, int>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_uo_to_int);
    IA_Image_IP_int_IA_RGB_to_int_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_uo_to_int);
    IA_Image_IP_int_IA_RGB_to_int_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_uo_to_int);

}
#endif // UOT_int_IA_RGB_to_int

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise to_float I(float) I(IA_RGB)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_IA_RGB_to_float
#define UOT_float_IA_RGB_to_float
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_float_IA_RGB_to_float_tbl;

void IA_fill_Image_IP_float_IA_RGB_to_float_tbl();
#endif


IA_Image<IA_Point<int>, float>
to_float ( const IA_Image<IA_Point<int>, IA_RGB> &arg)
{
    if (!IA_Image_IP_float_IA_RGB_to_float_tbl)
	IA_fill_Image_IP_float_IA_RGB_to_float_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_float_IA_RGB_to_float_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, IA_RGB>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_IA_RGB_to_float
#define vec_uop_float_IA_RGB_to_float
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_to_float(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_VectorI<IA_Point<int>, IA_RGB> *lhs =
	(IA_VectorI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const IA_RGB *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = to_float(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_IA_RGB_to_float

#ifndef scalar_uop_float_IA_RGB_to_float
#define scalar_uop_float_IA_RGB_to_float
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_to_float(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_ConstI<IA_Point<int>, IA_RGB> *lhs =
	(IA_ConstI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, to_float(lhs->value));
}
#endif // scalar_uop_float_IA_RGB_to_float

// scalar-scalar operation is trivial

#ifndef iter_uop_float_IA_RGB_to_float
#define iter_uop_float_IA_RGB_to_float
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_to_float(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = to_float(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_IA_RGB_to_float

#ifndef FILL_UOT_float_IA_RGB_to_float
#define FILL_UOT_float_IA_RGB_to_float
void IA_fill_Image_IP_float_IA_RGB_to_float_tbl()
{
    if (IA_Image_IP_float_IA_RGB_to_float_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_uo_to_float;

    IA_Image_IP_float_IA_RGB_to_float_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_uo_to_float);
    IA_Image_IP_float_IA_RGB_to_float_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_uo_to_float);
    IA_Image_IP_float_IA_RGB_to_float_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_uo_to_float);

}
#endif // UOT_float_IA_RGB_to_float

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise red I(u_char) I(IA_RGB)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_u_char_IA_RGB_red
#define UOT_u_char_IA_RGB_red
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_u_char_IA_RGB_red_tbl;

void IA_fill_Image_IP_u_char_IA_RGB_red_tbl();
#endif


IA_Image<IA_Point<int>, u_char>
red ( const IA_Image<IA_Point<int>, IA_RGB> &arg)
{
    if (!IA_Image_IP_u_char_IA_RGB_red_tbl)
	IA_fill_Image_IP_u_char_IA_RGB_red_tbl();

    IA_BaseImage<IA_Point<int>, u_char>*(*f)
	(IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_u_char_IA_RGB_red_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, IA_RGB>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_u_char_IA_RGB_red
#define vec_uop_u_char_IA_RGB_red
static IA_BaseImage<IA_Point<int>, u_char>*
vec_uo_red(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_VectorI<IA_Point<int>, IA_RGB> *lhs =
	(IA_VectorI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const IA_RGB *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = red(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // vec_uop_u_char_IA_RGB_red

#ifndef scalar_uop_u_char_IA_RGB_red
#define scalar_uop_u_char_IA_RGB_red
static IA_BaseImage<IA_Point<int>, u_char>*
scalar_uo_red(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_ConstI<IA_Point<int>, IA_RGB> *lhs =
	(IA_ConstI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, u_char>(domain, red(lhs->value));
}
#endif // scalar_uop_u_char_IA_RGB_red

// scalar-scalar operation is trivial

#ifndef iter_uop_u_char_IA_RGB_red
#define iter_uop_u_char_IA_RGB_red
static IA_BaseImage<IA_Point<int>, u_char>*
iter_uo_red(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = red(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // iter_uop_u_char_IA_RGB_red

#ifndef FILL_UOT_u_char_IA_RGB_red
#define FILL_UOT_u_char_IA_RGB_red
void IA_fill_Image_IP_u_char_IA_RGB_red_tbl()
{
    if (IA_Image_IP_u_char_IA_RGB_red_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_uo_red;

    IA_Image_IP_u_char_IA_RGB_red_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_uo_red);
    IA_Image_IP_u_char_IA_RGB_red_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_uo_red);
    IA_Image_IP_u_char_IA_RGB_red_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_uo_red);

}
#endif // UOT_u_char_IA_RGB_red

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise green I(u_char) I(IA_RGB)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_u_char_IA_RGB_green
#define UOT_u_char_IA_RGB_green
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_u_char_IA_RGB_green_tbl;

void IA_fill_Image_IP_u_char_IA_RGB_green_tbl();
#endif


IA_Image<IA_Point<int>, u_char>
green ( const IA_Image<IA_Point<int>, IA_RGB> &arg)
{
    if (!IA_Image_IP_u_char_IA_RGB_green_tbl)
	IA_fill_Image_IP_u_char_IA_RGB_green_tbl();

    IA_BaseImage<IA_Point<int>, u_char>*(*f)
	(IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_u_char_IA_RGB_green_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, IA_RGB>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_u_char_IA_RGB_green
#define vec_uop_u_char_IA_RGB_green
static IA_BaseImage<IA_Point<int>, u_char>*
vec_uo_green(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_VectorI<IA_Point<int>, IA_RGB> *lhs =
	(IA_VectorI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const IA_RGB *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = green(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // vec_uop_u_char_IA_RGB_green

#ifndef scalar_uop_u_char_IA_RGB_green
#define scalar_uop_u_char_IA_RGB_green
static IA_BaseImage<IA_Point<int>, u_char>*
scalar_uo_green(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_ConstI<IA_Point<int>, IA_RGB> *lhs =
	(IA_ConstI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, u_char>(domain, green(lhs->value));
}
#endif // scalar_uop_u_char_IA_RGB_green

// scalar-scalar operation is trivial

#ifndef iter_uop_u_char_IA_RGB_green
#define iter_uop_u_char_IA_RGB_green
static IA_BaseImage<IA_Point<int>, u_char>*
iter_uo_green(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = green(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // iter_uop_u_char_IA_RGB_green

#ifndef FILL_UOT_u_char_IA_RGB_green
#define FILL_UOT_u_char_IA_RGB_green
void IA_fill_Image_IP_u_char_IA_RGB_green_tbl()
{
    if (IA_Image_IP_u_char_IA_RGB_green_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_uo_green;

    IA_Image_IP_u_char_IA_RGB_green_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_uo_green);
    IA_Image_IP_u_char_IA_RGB_green_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_uo_green);
    IA_Image_IP_u_char_IA_RGB_green_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_uo_green);

}
#endif // UOT_u_char_IA_RGB_green

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise blue I(u_char) I(IA_RGB)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_u_char_IA_RGB_blue
#define UOT_u_char_IA_RGB_blue
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_u_char_IA_RGB_blue_tbl;

void IA_fill_Image_IP_u_char_IA_RGB_blue_tbl();
#endif


IA_Image<IA_Point<int>, u_char>
blue ( const IA_Image<IA_Point<int>, IA_RGB> &arg)
{
    if (!IA_Image_IP_u_char_IA_RGB_blue_tbl)
	IA_fill_Image_IP_u_char_IA_RGB_blue_tbl();

    IA_BaseImage<IA_Point<int>, u_char>*(*f)
	(IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_u_char_IA_RGB_blue_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, IA_RGB>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, u_char,u_char,u_char>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_u_char_IA_RGB_blue
#define vec_uop_u_char_IA_RGB_blue
static IA_BaseImage<IA_Point<int>, u_char>*
vec_uo_blue(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_VectorI<IA_Point<int>, IA_RGB> *lhs =
	(IA_VectorI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const IA_RGB *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = blue(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // vec_uop_u_char_IA_RGB_blue

#ifndef scalar_uop_u_char_IA_RGB_blue
#define scalar_uop_u_char_IA_RGB_blue
static IA_BaseImage<IA_Point<int>, u_char>*
scalar_uo_blue(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_)
{
    const IA_ConstI<IA_Point<int>, IA_RGB> *lhs =
	(IA_ConstI<IA_Point<int>, IA_RGB> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, u_char>(domain, blue(lhs->value));
}
#endif // scalar_uop_u_char_IA_RGB_blue

// scalar-scalar operation is trivial

#ifndef iter_uop_u_char_IA_RGB_blue
#define iter_uop_u_char_IA_RGB_blue
static IA_BaseImage<IA_Point<int>, u_char>*
iter_uo_blue(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = blue(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, u_char>(domain, vec, sz, 1);
}
#endif // iter_uop_u_char_IA_RGB_blue

#ifndef FILL_UOT_u_char_IA_RGB_blue
#define FILL_UOT_u_char_IA_RGB_blue
void IA_fill_Image_IP_u_char_IA_RGB_blue_tbl()
{
    if (IA_Image_IP_u_char_IA_RGB_blue_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_uo_blue;

    IA_Image_IP_u_char_IA_RGB_blue_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, u_char>*,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_uo_blue);
    IA_Image_IP_u_char_IA_RGB_blue_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_uo_blue);
    IA_Image_IP_u_char_IA_RGB_blue_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_uo_blue);

}
#endif // UOT_u_char_IA_RGB_blue

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== int I(IA_RGB) I(IA_RGB)
//
#ifndef BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
#define BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl;

void IA_fill_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl();

#endif // BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
int operator== ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		const IA_Image<IA_Point<int>, IA_RGB> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 int	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl)
	IA_fill_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,IA_RGB>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(rhs);
    return 	 f(basel,baser);
}

//
//
//

static int vec_vec_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *rhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&rhs_;
	const IA_RGB *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) == (*rs) ))
		return 0;
	    ls++;
	    rs++;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
#define vec_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
static int vec_scalar_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) == (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq

static int vec_iter_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (*ls) == (rtmp) ))
		return 0;
	    ls++;
	}
	delete riter;
    }
    return 1;
}

#ifndef scalar_vec_int_IA_RGB_IA_RGB_operatorIAOPeq
#define scalar_vec_int_IA_RGB_IA_RGB_operatorIAOPeq
static int scalar_vec_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_scalar_bo_operatorIAOPeq(rhs_, lhs_);
}
#endif // scalar_vec_int_IA_RGB_IA_RGB_operatorIAOPeq

#ifndef scalar_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
#define scalar_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
static int scalar_scalar_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    int	aval = ( lhs->value == rhs->value );
    return aval;
}
#endif // scalar_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq

#ifndef scalar_iter_int_IA_RGB_IA_RGB_operatorIAOPeq
#define scalar_iter_int_IA_RGB_IA_RGB_operatorIAOPeq
static int scalar_iter_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) == (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_IA_RGB_IA_RGB_operatorIAOPeq

static int iter_vec_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_iter_bo_operatorIAOPeq(rhs_, lhs_);
}

#ifndef iter_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
#define iter_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
static int iter_scalar_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_operatorIAOPeq(rhs_, lhs_);
}
#endif // iter_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq

static int iter_iter_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs_.value_iterator();
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    if (!( (ltmp) == (rtmp) ))
		return 0;
	}
	delete liter;
	delete riter;
    }
    return 1;
}

#ifndef FILL_BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
#define FILL_BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
void IA_fill_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl()
{
    if (IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_operatorIAOPeq;

    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPeq);

    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPeq);

    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_operatorIAOPeq);

}
#endif // BOT_int_IA_RGB_IA_RGB_operatorIAOPeq

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== int I(IA_RGB) IA_RGB
//
#ifndef BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
#define BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl;

void IA_fill_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl();

#endif // BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
int operator== ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		IA_RGB rhs)
{
    if (!IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl)
	IA_fill_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, IA_RGB>::s_type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,IA_RGB>	baser(lhs.domain(), rhs);
    return 	 f(basel,baser);
}

//
//
//

#ifndef vec_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
#define vec_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
static int vec_scalar_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) == (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq

#ifndef scalar_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
#define scalar_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
static int scalar_scalar_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    int	aval = ( lhs->value == rhs->value );
    return aval;
}
#endif // scalar_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq

#ifndef scalar_iter_int_IA_RGB_IA_RGB_operatorIAOPeq
#define scalar_iter_int_IA_RGB_IA_RGB_operatorIAOPeq
static int scalar_iter_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) == (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_IA_RGB_IA_RGB_operatorIAOPeq

#ifndef iter_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
#define iter_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq
static int iter_scalar_bo_operatorIAOPeq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_operatorIAOPeq(rhs_, lhs_);
}
#endif // iter_scalar_int_IA_RGB_IA_RGB_operatorIAOPeq

#ifndef FILL_BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
#define FILL_BOT_int_IA_RGB_IA_RGB_operatorIAOPeq
void IA_fill_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl()
{
    if (IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_operatorIAOPeq;

    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_operatorIAOPeq);

    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_operatorIAOPeq);

    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_operatorIAOPeq);
    IA_Image_IP_int_IA_RGB_IA_RGB_operatorIAOPeq_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_operatorIAOPeq);

}
#endif // BOT_int_IA_RGB_IA_RGB_operatorIAOPeq

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= int I(IA_RGB) I(IA_RGB)
//
#ifndef BOT_int_IA_RGB_IA_RGB_strict_ne
#define BOT_int_IA_RGB_IA_RGB_strict_ne
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl;

void IA_fill_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl();

#endif // BOT_int_IA_RGB_IA_RGB_strict_ne
int strict_ne ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		const IA_Image<IA_Point<int>, IA_RGB> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 int	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl)
	IA_fill_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,IA_RGB>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(rhs);
    return 	 f(basel,baser);
}

//
//
//

static int vec_vec_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *rhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&rhs_;
	const IA_RGB *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) != (*rs) ))
		return 0;
	    ls++;
	    rs++;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_IA_RGB_IA_RGB_strict_ne
#define vec_scalar_int_IA_RGB_IA_RGB_strict_ne
static int vec_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) != (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_IA_RGB_IA_RGB_strict_ne

static int vec_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (*ls) != (rtmp) ))
		return 0;
	    ls++;
	}
	delete riter;
    }
    return 1;
}

#ifndef scalar_vec_int_IA_RGB_IA_RGB_strict_ne
#define scalar_vec_int_IA_RGB_IA_RGB_strict_ne
static int scalar_vec_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_scalar_bo_strict_ne(rhs_, lhs_);
}
#endif // scalar_vec_int_IA_RGB_IA_RGB_strict_ne

#ifndef scalar_scalar_int_IA_RGB_IA_RGB_strict_ne
#define scalar_scalar_int_IA_RGB_IA_RGB_strict_ne
static int scalar_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    int	aval = ( lhs->value != rhs->value );
    return aval;
}
#endif // scalar_scalar_int_IA_RGB_IA_RGB_strict_ne

#ifndef scalar_iter_int_IA_RGB_IA_RGB_strict_ne
#define scalar_iter_int_IA_RGB_IA_RGB_strict_ne
static int scalar_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) != (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_IA_RGB_IA_RGB_strict_ne

static int iter_vec_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_iter_bo_strict_ne(rhs_, lhs_);
}

#ifndef iter_scalar_int_IA_RGB_IA_RGB_strict_ne
#define iter_scalar_int_IA_RGB_IA_RGB_strict_ne
static int iter_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_strict_ne(rhs_, lhs_);
}
#endif // iter_scalar_int_IA_RGB_IA_RGB_strict_ne

static int iter_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs_.value_iterator();
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    if (!( (ltmp) != (rtmp) ))
		return 0;
	}
	delete liter;
	delete riter;
    }
    return 1;
}

#ifndef FILL_BOT_int_IA_RGB_IA_RGB_strict_ne
#define FILL_BOT_int_IA_RGB_IA_RGB_strict_ne
void IA_fill_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl()
{
    if (IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_strict_ne;

    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_strict_ne);

    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_strict_ne);

    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_strict_ne);

}
#endif // BOT_int_IA_RGB_IA_RGB_strict_ne

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= int I(IA_RGB) IA_RGB
//
#ifndef BOT_int_IA_RGB_IA_RGB_strict_ne
#define BOT_int_IA_RGB_IA_RGB_strict_ne
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl;

void IA_fill_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl();

#endif // BOT_int_IA_RGB_IA_RGB_strict_ne
int strict_ne ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		IA_RGB rhs)
{
    if (!IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl)
	IA_fill_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, IA_RGB>::s_type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,IA_RGB>	baser(lhs.domain(), rhs);
    return 	 f(basel,baser);
}

//
//
//

#ifndef vec_scalar_int_IA_RGB_IA_RGB_strict_ne
#define vec_scalar_int_IA_RGB_IA_RGB_strict_ne
static int vec_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) != (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_IA_RGB_IA_RGB_strict_ne

#ifndef scalar_scalar_int_IA_RGB_IA_RGB_strict_ne
#define scalar_scalar_int_IA_RGB_IA_RGB_strict_ne
static int scalar_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    int	aval = ( lhs->value != rhs->value );
    return aval;
}
#endif // scalar_scalar_int_IA_RGB_IA_RGB_strict_ne

#ifndef scalar_iter_int_IA_RGB_IA_RGB_strict_ne
#define scalar_iter_int_IA_RGB_IA_RGB_strict_ne
static int scalar_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) != (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_IA_RGB_IA_RGB_strict_ne

#ifndef iter_scalar_int_IA_RGB_IA_RGB_strict_ne
#define iter_scalar_int_IA_RGB_IA_RGB_strict_ne
static int iter_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_strict_ne(rhs_, lhs_);
}
#endif // iter_scalar_int_IA_RGB_IA_RGB_strict_ne

#ifndef FILL_BOT_int_IA_RGB_IA_RGB_strict_ne
#define FILL_BOT_int_IA_RGB_IA_RGB_strict_ne
void IA_fill_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl()
{
    if (IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_strict_ne;

    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_strict_ne);

    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_strict_ne);

    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_strict_ne);
    IA_Image_IP_int_IA_RGB_IA_RGB_strict_ne_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_strict_ne);

}
#endif // BOT_int_IA_RGB_IA_RGB_strict_ne

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative chi_eq subop=operator== I(IA_Bit) I(IA_RGB) I(IA_RGB)
//
#ifndef BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl;

void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl();

#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
IA_Image<IA_Point<int>, IA_Bit>
chi_eq ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		const IA_Image<IA_Point<int>, IA_RGB> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, IA_Bit>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl)
	IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl();

    IA_BaseImage<IA_Point<int>, IA_Bit>*(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,IA_RGB>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,IA_Bit>
	(IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_vec_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *rhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&rhs_;
	const IA_RGB *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) == (*rs) );
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) == (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq

static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (*ls) == (rtmp) );
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef scalar_vec_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define scalar_vec_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_vec_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_scalar_bo_chi_eq(rhs_, lhs_);
}
#endif // scalar_vec_IA_Bit_IA_RGB_IA_RGB_chi_eq

#ifndef scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    IA_Bit	aval = ( lhs->value == rhs->value );
    return new IA_ConstI<IA_Point<int>, IA_Bit>(domain, aval);
}
#endif // scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq

#ifndef scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) == (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_eq

static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_vec_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_iter_bo_chi_eq(rhs_, lhs_);
}

#ifndef iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_chi_eq(rhs_, lhs_);
}
#endif // iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq

static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs_.value_iterator();
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = ( (ltmp) == (rtmp) );
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl()
{
    if (IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_chi_eq;

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_chi_eq);

}
#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative chi_eq subop=operator== I(IA_Bit) I(IA_RGB) IA_RGB
//
#ifndef BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl;

void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl();

#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
IA_Image<IA_Point<int>, IA_Bit>
chi_eq ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		IA_RGB rhs)
{
    if (!IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl)
	IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl();

    IA_BaseImage<IA_Point<int>, IA_Bit>*(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, IA_RGB>::s_type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,IA_RGB>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,IA_Bit>
	(IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) == (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq

#ifndef scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    IA_Bit	aval = ( lhs->value == rhs->value );
    return new IA_ConstI<IA_Point<int>, IA_Bit>(domain, aval);
}
#endif // scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq

#ifndef scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) == (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_eq

#ifndef iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_chi_eq(rhs_, lhs_);
}
#endif // iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_eq

#ifndef FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
#define FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq
void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl()
{
    if (IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_chi_eq;

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_eq_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_chi_eq);

}
#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_eq

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative chi_ne subop=operator!= I(IA_Bit) I(IA_RGB) I(IA_RGB)
//
#ifndef BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl;

void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl();

#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
IA_Image<IA_Point<int>, IA_Bit>
chi_ne ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		const IA_Image<IA_Point<int>, IA_RGB> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, IA_Bit>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl)
	IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl();

    IA_BaseImage<IA_Point<int>, IA_Bit>*(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,IA_RGB>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,IA_Bit>
	(IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_vec_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *rhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&rhs_;
	const IA_RGB *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) != (*rs) );
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_scalar_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) != (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne

static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_iter_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (*ls) != (rtmp) );
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef scalar_vec_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define scalar_vec_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_vec_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_scalar_bo_chi_ne(rhs_, lhs_);
}
#endif // scalar_vec_IA_Bit_IA_RGB_IA_RGB_chi_ne

#ifndef scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_scalar_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    IA_Bit	aval = ( lhs->value != rhs->value );
    return new IA_ConstI<IA_Point<int>, IA_Bit>(domain, aval);
}
#endif // scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne

#ifndef scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_iter_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) != (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_ne

static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_vec_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return vec_iter_bo_chi_ne(rhs_, lhs_);
}

#ifndef iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_scalar_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_chi_ne(rhs_, lhs_);
}
#endif // iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne

static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_iter_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_RGB ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*liter = lhs_.value_iterator();
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = ( (ltmp) != (rtmp) );
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl()
{
    if (IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_chi_ne;

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_chi_ne);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_chi_ne);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_chi_ne);

}
#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative chi_ne subop=operator!= I(IA_Bit) I(IA_RGB) IA_RGB
//
#ifndef BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >
	*IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl;

void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl();

#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
IA_Image<IA_Point<int>, IA_Bit>
chi_ne ( const IA_Image<IA_Point<int>, IA_RGB> &lhs,
		IA_RGB rhs)
{
    if (!IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl)
	IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl();

    IA_BaseImage<IA_Point<int>, IA_Bit>*(*f)( IA_BaseImage<IA_Point<int>, IA_RGB> &,
		IA_BaseImage<IA_Point<int>, IA_RGB> &);
    f = IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, IA_RGB>::s_type());
    IA_BaseImage<IA_Point<int>,IA_RGB>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_RGB,IA_RGB,IA_RGB>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,IA_RGB>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,IA_Bit>
	(IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_scalar_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, IA_RGB> *lhs
		= (IA_VectorI<IA_Point<int>, IA_RGB> *)&lhs_;
	const IA_RGB *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) != (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // vec_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne

#ifndef scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_scalar_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_RGB> *rhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&rhs_;
    IA_Bit	aval = ( lhs->value != rhs->value );
    return new IA_ConstI<IA_Point<int>, IA_Bit>(domain, aval);
}
#endif // scalar_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne

#ifndef scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_iter_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_ConstI<IA_Point<int>, IA_RGB> *lhs
		= (IA_ConstI<IA_Point<int>, IA_RGB> *)&lhs_;
	IA_RGB rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_RGB>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) != (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // scalar_iter_IA_Bit_IA_RGB_IA_RGB_chi_ne

#ifndef iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne
static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_scalar_bo_chi_ne(IA_BaseImage<IA_Point<int>, IA_RGB> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_RGB> &rhs_)
{
    return scalar_iter_bo_chi_ne(rhs_, lhs_);
}
#endif // iter_scalar_IA_Bit_IA_RGB_IA_RGB_chi_ne

#ifndef FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
#define FILL_BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne
void IA_fill_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl()
{
    if (IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >::function f;
    f = iter_iter_bo_chi_ne;

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, IA_RGB>,
	IA_BaseImage<IA_Point<int>, IA_RGB> >(iter_iter_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_vec_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 vec_scalar_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 vec_iter_bo_chi_ne);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_vec_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 scalar_scalar_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 0,
	 scalar_iter_bo_chi_ne);

    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_vec_bo_chi_ne);
    IA_Image_IP_IA_Bit_IA_RGB_IA_RGB_chi_ne_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_RGB>::s_type(),
	 iter_scalar_bo_chi_ne);

}
#endif // BOT_IA_Bit_IA_RGB_IA_RGB_chi_ne

