// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FuncI.c,v $

#ifndef LazyImage_h_
#define LazyImage_h_

#include "BaseI.h"

template <class P, class T>
class IA_LazyReflectionImage : public IA_BaseImage<P,T>
{
    static char type_;
    IA_BaseImage<P,T>	*arg;
public:
    IA_LazyReflectionImage(IA_BaseImage<P,T> *arg_);
    ~IA_LazyReflectionImage();

    int extensive() const { return 0;}
    T operator() (const P &ip) const { return (*arg)(-ip); }
    IA::Type type() const { return &type_; }
    IA_BaseImage<P,T> *reflection() const { return arg; }
    ostream & print_this(ostream &o) const;
};

#endif // LazyImage_h_
