// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: InvNbh.h,v $
// Revision 1.1  1994/01/31  16:43:38  thoth
// Initial revision
//

#ifndef InvariantNbh_h_
#define InvariantNbh_h_

#include "BaseNbh.h"

template <class P, class Q>
class IA_InvariantNbh: public IA_BaseNbh<P,Q> {
  private:
    static char dummy;

  public:
    IA_Set<P>	value;
  public:
    IA_InvariantNbh(const IA_Set<Q> &ps, const IA_Set<P> &v)
    :IA_BaseNbh<P,Q>(ps), value(v) {}

    int extensive() const { return 0; }

    IA_Set<P> operator()(const Q &p) const {
	return value + p;
    }
    ostream &print_this(ostream &) const;

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }
};

#endif
