// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FuncI.c,v $
// Revision 1.5.1.1  1994/12/28  16:56:06  thoth
// Conversion to classes for throw.
//
// Revision 1.5  1994/09/16  14:57:11  thoth
// more DOS-inspired renaming.
//
// Revision 1.4  1994/02/26  16:02:08  thoth
// operator() of the container now relies upon the contained classes
// to check if p is contained in the domain.  This means that users
// could possibly write an erroneous operator().
//
// Revision 1.3  1993/12/29  16:54:24  thoth
// Added FunctionI that accepts functions with simple T type instead of
// const T&
//
// Revision 1.2  1993/11/17  18:18:51  thoth
// IPSIter is now PSIter<IntPoint>.
// extensivep is now extensive.
//
// Revision 1.1  1993/09/15  12:52:49  thoth
// Initial revision
//

#include "FuncI.h"
#include "PSIter.h"
#include "image_errors.h"

template < class P,class T>
char IA_FunctionRefI<P,T>::dummy = 0;

template < class P,class T>
T IA_FunctionRefI<P,T>::operator ()(const P& p) const {
    if (!domain().contains(p)) {
	ia_throw(Image_PointOutsideDomain_Exception(__FILE__,__LINE__));
    }
    return (*(this->func))(p);
}

template < class P,class T>
ostream& IA_FunctionRefI<P,T>::print_this(ostream& o) const
{
    o << "FunctionRefI -";
    if (this->ps.extensive()){
	IA_PSIter<P> iter(this->ps);
	P p;
	
	o << "(point,value) pairs follow:\n";
	while(iter(p)) {
	    o << "(" << p << "," << (*this->func)(p) << ") ";
	}
    } else {
	o << " Function : " << (int)(this->func) <<
	    ", PointSet : Comprehensive";
    }
    return o << "\n";
}

//
//
//

template < class P,class T>
char IA_FunctionI<P,T>::dummy = 0;

template < class P,class T>
T IA_FunctionI<P,T>::operator ()(const P& p) const {
    if (!domain().contains(p)) {
	ia_throw(Image_PointOutsideDomain_Exception(__FILE__,__LINE__));
    }
    return (*(this->func))(p);
}

template < class P,class T>
ostream& IA_FunctionI<P,T>::print_this(ostream& o) const
{
    o << "FunctionI -";
    if (this->ps.extensive()){
	IA_PSIter<P> iter(this->ps);
	P p;
	
	o << "(point,value) pairs follow:\n";
	while(iter(p)) {
	    o << "(" << p << "," << (*this->func)(p) << ") ";
	}
    } else {
	o << " Function : " << (int)(this->func) <<
	    ", PointSet : Comprehensive";
    }
    return o << "\n";
}
