// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: cplx-operations.desc,v $
//  Revision 1.8.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.8.1.1  1994/12/28  18:06:11  thoth
//  image operations are now friendly with FBI.
//  image ops now use operations table instead of switch.

//  Revision 1.8  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.7  1994/08/22  15:20:29  thoth
//  DOS-inspired name rework.

//  Revision 1.6  1994/05/27  15:33:15  thoth
//  Pass-through C code wasn't passing through.

//  Revision 1.5  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Revision 1.4  1994/02/03  16:22:48  thoth
//  Arguments to binary operations were specified "lhs rhs return" but are
//  now specified "return lhs rhs" to be consistent with function declaration
//  syntax.

//  Revision 1.3  1994/01/31  15:54:13  thoth
//  chi_functions now return BitDIs.
//  more pointwise complex functions.

//  Revision 1.2  1993/12/29  17:27:24  thoth
//  reductions require a zero now.

//  Revision 1.1  1993/11/29  22:25:25  thoth
//  Initial revision

// include <complex.h>
#include "CplxDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sqrt I(complex) I(complex)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_complex_complex_sqrt
#define UOT_complex_complex_sqrt
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_complex_complex_sqrt_tbl;

void IA_fill_Image_IP_complex_complex_sqrt_tbl();
#endif


IA_Image<IA_Point<int>, complex>
sqrt ( const IA_Image<IA_Point<int>, complex> &arg)
{
    if (!IA_Image_IP_complex_complex_sqrt_tbl)
	IA_fill_Image_IP_complex_complex_sqrt_tbl();

    IA_BaseImage<IA_Point<int>, complex>*(*f)
	(IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_complex_complex_sqrt_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, complex>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,complex,complex,complex>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, complex,complex,complex>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_complex_complex_sqrt
#define vec_uop_complex_complex_sqrt
static IA_BaseImage<IA_Point<int>, complex>*
vec_uo_sqrt(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_VectorI<IA_Point<int>, complex> *lhs =
	(IA_VectorI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    complex *const vec = new complex[sz];

    {
	complex *ds = vec;
	const complex *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sqrt(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, complex>(domain, vec, sz, 1);
}
#endif // vec_uop_complex_complex_sqrt

#ifndef scalar_uop_complex_complex_sqrt
#define scalar_uop_complex_complex_sqrt
static IA_BaseImage<IA_Point<int>, complex>*
scalar_uo_sqrt(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_ConstI<IA_Point<int>, complex> *lhs =
	(IA_ConstI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, complex>(domain, sqrt(lhs->value));
}
#endif // scalar_uop_complex_complex_sqrt

// scalar-scalar operation is trivial

#ifndef iter_uop_complex_complex_sqrt
#define iter_uop_complex_complex_sqrt
static IA_BaseImage<IA_Point<int>, complex>*
iter_uo_sqrt(IA_BaseImage<IA_Point<int>, complex> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    complex *const vec = new complex[sz];

    {
	complex *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = sqrt(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, complex>(domain, vec, sz, 1);
}
#endif // iter_uop_complex_complex_sqrt

#ifndef FILL_UOT_complex_complex_sqrt
#define FILL_UOT_complex_complex_sqrt
void IA_fill_Image_IP_complex_complex_sqrt_tbl()
{
    if (IA_Image_IP_complex_complex_sqrt_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_uo_sqrt;

    IA_Image_IP_complex_complex_sqrt_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >(iter_uo_sqrt);
    IA_Image_IP_complex_complex_sqrt_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_uo_sqrt);
    IA_Image_IP_complex_complex_sqrt_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_uo_sqrt);

}
#endif // UOT_complex_complex_sqrt

template <class T>
inline T sqr(T v)
{
    return v*v;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sqr I(complex) I(complex)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_complex_complex_sqr
#define UOT_complex_complex_sqr
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_complex_complex_sqr_tbl;

void IA_fill_Image_IP_complex_complex_sqr_tbl();
#endif


IA_Image<IA_Point<int>, complex>
sqr ( const IA_Image<IA_Point<int>, complex> &arg)
{
    if (!IA_Image_IP_complex_complex_sqr_tbl)
	IA_fill_Image_IP_complex_complex_sqr_tbl();

    IA_BaseImage<IA_Point<int>, complex>*(*f)
	(IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_complex_complex_sqr_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, complex>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,complex,complex,complex>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, complex,complex,complex>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_complex_complex_sqr
#define vec_uop_complex_complex_sqr
static IA_BaseImage<IA_Point<int>, complex>*
vec_uo_sqr(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_VectorI<IA_Point<int>, complex> *lhs =
	(IA_VectorI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    complex *const vec = new complex[sz];

    {
	complex *ds = vec;
	const complex *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sqr(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, complex>(domain, vec, sz, 1);
}
#endif // vec_uop_complex_complex_sqr

#ifndef scalar_uop_complex_complex_sqr
#define scalar_uop_complex_complex_sqr
static IA_BaseImage<IA_Point<int>, complex>*
scalar_uo_sqr(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_ConstI<IA_Point<int>, complex> *lhs =
	(IA_ConstI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, complex>(domain, sqr(lhs->value));
}
#endif // scalar_uop_complex_complex_sqr

// scalar-scalar operation is trivial

#ifndef iter_uop_complex_complex_sqr
#define iter_uop_complex_complex_sqr
static IA_BaseImage<IA_Point<int>, complex>*
iter_uo_sqr(IA_BaseImage<IA_Point<int>, complex> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    complex *const vec = new complex[sz];

    {
	complex *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = sqr(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, complex>(domain, vec, sz, 1);
}
#endif // iter_uop_complex_complex_sqr

#ifndef FILL_UOT_complex_complex_sqr
#define FILL_UOT_complex_complex_sqr
void IA_fill_Image_IP_complex_complex_sqr_tbl()
{
    if (IA_Image_IP_complex_complex_sqr_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_uo_sqr;

    IA_Image_IP_complex_complex_sqr_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >(iter_uo_sqr);
    IA_Image_IP_complex_complex_sqr_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_uo_sqr);
    IA_Image_IP_complex_complex_sqr_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_uo_sqr);

}
#endif // UOT_complex_complex_sqr

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise abs_f subop=abs I(float) I(complex)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_complex_abs_f
#define UOT_float_complex_abs_f
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_float_complex_abs_f_tbl;

void IA_fill_Image_IP_float_complex_abs_f_tbl();
#endif


IA_Image<IA_Point<int>, float>
abs_f ( const IA_Image<IA_Point<int>, complex> &arg)
{
    if (!IA_Image_IP_float_complex_abs_f_tbl)
	IA_fill_Image_IP_float_complex_abs_f_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_float_complex_abs_f_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, complex>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,complex,complex,complex>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_complex_abs_f
#define vec_uop_float_complex_abs_f
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_abs_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_VectorI<IA_Point<int>, complex> *lhs =
	(IA_VectorI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const complex *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = abs(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_complex_abs_f

#ifndef scalar_uop_float_complex_abs_f
#define scalar_uop_float_complex_abs_f
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_abs_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_ConstI<IA_Point<int>, complex> *lhs =
	(IA_ConstI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, abs(lhs->value));
}
#endif // scalar_uop_float_complex_abs_f

// scalar-scalar operation is trivial

#ifndef iter_uop_float_complex_abs_f
#define iter_uop_float_complex_abs_f
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_abs_f(IA_BaseImage<IA_Point<int>, complex> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = abs(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_complex_abs_f

#ifndef FILL_UOT_float_complex_abs_f
#define FILL_UOT_float_complex_abs_f
void IA_fill_Image_IP_float_complex_abs_f_tbl()
{
    if (IA_Image_IP_float_complex_abs_f_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_uo_abs_f;

    IA_Image_IP_float_complex_abs_f_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >(iter_uo_abs_f);
    IA_Image_IP_float_complex_abs_f_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_uo_abs_f);
    IA_Image_IP_float_complex_abs_f_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_uo_abs_f);

}
#endif // UOT_float_complex_abs_f

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise arg_f subop=abs I(float) I(complex)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_complex_arg_f
#define UOT_float_complex_arg_f
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_float_complex_arg_f_tbl;

void IA_fill_Image_IP_float_complex_arg_f_tbl();
#endif


IA_Image<IA_Point<int>, float>
arg_f ( const IA_Image<IA_Point<int>, complex> &arg)
{
    if (!IA_Image_IP_float_complex_arg_f_tbl)
	IA_fill_Image_IP_float_complex_arg_f_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_float_complex_arg_f_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, complex>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,complex,complex,complex>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_complex_arg_f
#define vec_uop_float_complex_arg_f
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_arg_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_VectorI<IA_Point<int>, complex> *lhs =
	(IA_VectorI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const complex *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = abs(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_complex_arg_f

#ifndef scalar_uop_float_complex_arg_f
#define scalar_uop_float_complex_arg_f
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_arg_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_ConstI<IA_Point<int>, complex> *lhs =
	(IA_ConstI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, abs(lhs->value));
}
#endif // scalar_uop_float_complex_arg_f

// scalar-scalar operation is trivial

#ifndef iter_uop_float_complex_arg_f
#define iter_uop_float_complex_arg_f
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_arg_f(IA_BaseImage<IA_Point<int>, complex> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = abs(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_complex_arg_f

#ifndef FILL_UOT_float_complex_arg_f
#define FILL_UOT_float_complex_arg_f
void IA_fill_Image_IP_float_complex_arg_f_tbl()
{
    if (IA_Image_IP_float_complex_arg_f_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_uo_arg_f;

    IA_Image_IP_float_complex_arg_f_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >(iter_uo_arg_f);
    IA_Image_IP_float_complex_arg_f_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_uo_arg_f);
    IA_Image_IP_float_complex_arg_f_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_uo_arg_f);

}
#endif // UOT_float_complex_arg_f

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise conj subop=conj I(complex) I(complex)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_complex_complex_conj
#define UOT_complex_complex_conj
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_complex_complex_conj_tbl;

void IA_fill_Image_IP_complex_complex_conj_tbl();
#endif


IA_Image<IA_Point<int>, complex>
conj ( const IA_Image<IA_Point<int>, complex> &arg)
{
    if (!IA_Image_IP_complex_complex_conj_tbl)
	IA_fill_Image_IP_complex_complex_conj_tbl();

    IA_BaseImage<IA_Point<int>, complex>*(*f)
	(IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_complex_complex_conj_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, complex>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,complex,complex,complex>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, complex,complex,complex>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_complex_complex_conj
#define vec_uop_complex_complex_conj
static IA_BaseImage<IA_Point<int>, complex>*
vec_uo_conj(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_VectorI<IA_Point<int>, complex> *lhs =
	(IA_VectorI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    complex *const vec = new complex[sz];

    {
	complex *ds = vec;
	const complex *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = conj(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, complex>(domain, vec, sz, 1);
}
#endif // vec_uop_complex_complex_conj

#ifndef scalar_uop_complex_complex_conj
#define scalar_uop_complex_complex_conj
static IA_BaseImage<IA_Point<int>, complex>*
scalar_uo_conj(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_ConstI<IA_Point<int>, complex> *lhs =
	(IA_ConstI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, complex>(domain, conj(lhs->value));
}
#endif // scalar_uop_complex_complex_conj

// scalar-scalar operation is trivial

#ifndef iter_uop_complex_complex_conj
#define iter_uop_complex_complex_conj
static IA_BaseImage<IA_Point<int>, complex>*
iter_uo_conj(IA_BaseImage<IA_Point<int>, complex> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    complex *const vec = new complex[sz];

    {
	complex *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = conj(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, complex>(domain, vec, sz, 1);
}
#endif // iter_uop_complex_complex_conj

#ifndef FILL_UOT_complex_complex_conj
#define FILL_UOT_complex_complex_conj
void IA_fill_Image_IP_complex_complex_conj_tbl()
{
    if (IA_Image_IP_complex_complex_conj_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_uo_conj;

    IA_Image_IP_complex_complex_conj_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, complex>*,
	IA_BaseImage<IA_Point<int>, complex> >(iter_uo_conj);
    IA_Image_IP_complex_complex_conj_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_uo_conj);
    IA_Image_IP_complex_complex_conj_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_uo_conj);

}
#endif // UOT_complex_complex_conj

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise imag_f subop=imag I(float) I(complex)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_complex_imag_f
#define UOT_float_complex_imag_f
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_float_complex_imag_f_tbl;

void IA_fill_Image_IP_float_complex_imag_f_tbl();
#endif


IA_Image<IA_Point<int>, float>
imag_f ( const IA_Image<IA_Point<int>, complex> &arg)
{
    if (!IA_Image_IP_float_complex_imag_f_tbl)
	IA_fill_Image_IP_float_complex_imag_f_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_float_complex_imag_f_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, complex>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,complex,complex,complex>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_complex_imag_f
#define vec_uop_float_complex_imag_f
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_imag_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_VectorI<IA_Point<int>, complex> *lhs =
	(IA_VectorI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const complex *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = imag(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_complex_imag_f

#ifndef scalar_uop_float_complex_imag_f
#define scalar_uop_float_complex_imag_f
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_imag_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_ConstI<IA_Point<int>, complex> *lhs =
	(IA_ConstI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, imag(lhs->value));
}
#endif // scalar_uop_float_complex_imag_f

// scalar-scalar operation is trivial

#ifndef iter_uop_float_complex_imag_f
#define iter_uop_float_complex_imag_f
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_imag_f(IA_BaseImage<IA_Point<int>, complex> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = imag(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_complex_imag_f

#ifndef FILL_UOT_float_complex_imag_f
#define FILL_UOT_float_complex_imag_f
void IA_fill_Image_IP_float_complex_imag_f_tbl()
{
    if (IA_Image_IP_float_complex_imag_f_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_uo_imag_f;

    IA_Image_IP_float_complex_imag_f_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >(iter_uo_imag_f);
    IA_Image_IP_float_complex_imag_f_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_uo_imag_f);
    IA_Image_IP_float_complex_imag_f_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_uo_imag_f);

}
#endif // UOT_float_complex_imag_f

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise real_f subop=real I(float) I(complex) 
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: unary-op.templ,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  17:22:11  thoth
// image operations are friends of FBI now.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:14  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:07:16  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef UOT_float_complex_real_f
#define UOT_float_complex_real_f
IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_float_complex_real_f_tbl;

void IA_fill_Image_IP_float_complex_real_f_tbl();
#endif


IA_Image<IA_Point<int>, float>
real_f ( const IA_Image<IA_Point<int>, complex> &arg)
{
    if (!IA_Image_IP_float_complex_real_f_tbl)
	IA_fill_Image_IP_float_complex_real_f_tbl();

    IA_BaseImage<IA_Point<int>, float>*(*f)
	(IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_float_complex_real_f_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, complex>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,complex,complex,complex>
	    ::extract_baseptr(arg);

    return IA_FBI<IA_Point<int>,IA_Point<int>, float,float,float>
	 ::make_Image(f(bip));
}

#ifndef vec_uop_float_complex_real_f
#define vec_uop_float_complex_real_f
static IA_BaseImage<IA_Point<int>, float>*
vec_uo_real_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_VectorI<IA_Point<int>, complex> *lhs =
	(IA_VectorI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const complex *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = real(*(ls++));
	}
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // vec_uop_float_complex_real_f

#ifndef scalar_uop_float_complex_real_f
#define scalar_uop_float_complex_real_f
static IA_BaseImage<IA_Point<int>, float>*
scalar_uo_real_f(IA_BaseImage<IA_Point<int>, complex> &lhs_)
{
    const IA_ConstI<IA_Point<int>, complex> *lhs =
	(IA_ConstI<IA_Point<int>, complex> *) &lhs_;

    const IA_Set<IA_Point<int> > domain = lhs->domain();

    return new IA_ConstI<IA_Point<int>, float>(domain, real(lhs->value));
}
#endif // scalar_uop_float_complex_real_f

// scalar-scalar operation is trivial

#ifndef iter_uop_float_complex_real_f
#define iter_uop_float_complex_real_f
static IA_BaseImage<IA_Point<int>, float>*
iter_uo_real_f(IA_BaseImage<IA_Point<int>, complex> &lhs)
{
    const IA_Set<IA_Point<int> > domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    *(ds++) = real(ltmp);
	}
	delete liter;
    }
    return new IA_VectorI<IA_Point<int>, float>(domain, vec, sz, 1);
}
#endif // iter_uop_float_complex_real_f

#ifndef FILL_UOT_float_complex_real_f
#define FILL_UOT_float_complex_real_f
void IA_fill_Image_IP_float_complex_real_f_tbl()
{
    if (IA_Image_IP_float_complex_real_f_tbl)
	return;

    IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_uo_real_f;

    IA_Image_IP_float_complex_real_f_tbl = new IA_UnaryOperationsTable<IA_BaseImage<IA_Point<int>, float>*,
	IA_BaseImage<IA_Point<int>, complex> >(iter_uo_real_f);
    IA_Image_IP_float_complex_real_f_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_uo_real_f);
    IA_Image_IP_float_complex_real_f_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_uo_real_f);

}
#endif // UOT_float_complex_real_f

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename CIO-reduce.c
//
