// -*- C++ -*-
//      Copyright 1993, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

#include "Stack.h"

static char IA_Stack_c_rcsid[] = "$Id: Stack.c,v 1.1 1994/04/27 18:26:09 rjj Exp $";

// $Log: Stack.c,v $
 * Revision 1.1  1994/04/27  18:26:09  rjj
 * Initial revision
 *

//==================================================================
//  IA_Stack<T> private memebers
//==================================================================

template <class T>
void  IA_Stack<T>::nullStack() {
    this->deleteCells();
}


/////////////////////////////////////////////////////////////////////////////
//
// class IA_Stack
//
/////////////////////////////////////////////////////////////////////////////


//================================================================
// Constructors & Destructor
//================================================================

template <class T>
IA_Stack<T>::IA_Stack() : IA_Deque<T>() {}


template <class T>
IA_Stack<T>::IA_Stack(const IA_Stack<T>& s) : IA_Deque<T>(s) {}


template <class T>
IA_Stack<T>::IA_Stack(T *vec, unsigned size)
: IA_Deque<T>(vec, size) {}


template <class T>
IA_Stack<T>::IA_Stack(T v0)    // Construct a stack with one element
: IA_Deque<T>(v0) {}


template <class T>
IA_Stack<T>::IA_Stack(T v0, T v1)
: IA_Deque<T>(v0, v1) {}


template <class T>
IA_Stack<T>::IA_Stack(T v0, T v1, T v2)
: IA_Deque<T>(v0, v1, v2) {}


template <class T>
IA_Stack<T>::IA_Stack(T v0, T v1, T v2, T v3)
: IA_Deque<T>(v0, v1, v2, v3) {}


template <class T>
IA_Stack<T>::IA_Stack(T v0, T v1, T v2, T v3, T v4)
: IA_Deque<T>(v0, v1, v2, v3, v4) {}


template <class T>
IA_Stack<T>::~IA_Stack() {
    // do nothing
}

template <class T>
IA_Stack<T>&  IA_Stack<T>::operator= (const IA_Stack<T>& rhs) {
    // Just defer this to the Deque
    this->IA_Deque<T>::operator=(rhs);
    return *this;
}

template <class T>
T&  IA_Stack<T>::operator[] (unsigned index) {
    // Just defer this to the Deque
    return this->IA_Deque<T>::operator[](index);
}

template <class T>
T  IA_Stack<T>::operator() (unsigned index) const {
    // Just defer this to the Deque
    return this->IA_Deque<T>::operator()(index);
}

template <class T>         // Is the IA_Stack empty? 
int  IA_Stack<T>::empty()  const {
    return this->IA_Deque<T>::empty();
}

template <class T>         // The number of elements in the stack
unsigned  IA_Stack<T>::length() const {
    return this->IA_Deque<T>::length();
}

template <class T>         // The top element in the stack
T  IA_Stack<T>::top() const {
    return this->IA_Deque<T>::last();
}

template <class T>         // Push the value onto the stack
void  IA_Stack<T>::push(T pushVal) {
    this->IA_Deque<T>::insBack(pushVal);
}

template <class T>         // Pop the top element off the stack
void  IA_Stack<T>::pop(T& popVal) {
    popVal = this->top();
    this->IA_Deque<T>::delBack();
};

