// Emacs -*- C++ -*-

//        Copyright 1993, Center for Computer Vision and Visualization,
//        University of Florida.  All rights reserved.

//
// $Log: point_errors.h,v $
// Revision 1.1.1.1  1994/12/08  14:36:23  thoth
// Several new error classes for throw rework.
//
// Revision 1.1  1994/11/30  16:19:07  thoth
// Initial revision
//

#ifndef point_errors_h_
#define point_errors_h_

#include "ia.h"

struct Point_DimensionMismatch_Exception : public GenericException {
    Point_DimensionMismatch_Exception(const char *fn, int l)
	:GenericException
	    ("Point: dimension mismatch in binary operation", fn ,l) { }
};

struct Point_BadIndex_Exception : public GenericException {
    Point_BadIndex_Exception(const char *fn, int l)
	:GenericException
	    ("Point: bad coordinate index", fn ,l) { }
};

struct Point_Uninitialized_Exception : public GenericException {
    Point_Uninitialized_Exception(const char *fn, int l)
	:GenericException
	    ("Point: operation attempted on uninitialized point", fn ,l) { }
};

struct Point_CrossProductRequireDimension3_Exception : public GenericException {
    Point_CrossProductRequireDimension3_Exception(const char *fn, int l)
	:GenericException
	    ("Point: cross product requires arguments to be of dimension 3",
	     fn, l) {}
};


#endif // point_errors_h_
