// Emacs -*- C++ -*-

//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

// $Log: compat.h,v $
// Revision 1.27  1994/12/28  21:45:45  ljr
// Doesn't define __CFRONT__ if appropriate, anymore, as per jnw.
//
// Revision 1.26  1994/12/22  23:54:13  ljr
// Added pid_t typedef for IA_NEED_TYPES.
//
// Revision 1.25  1994/12/22  23:48:32  ljr
// Now defines __CFRONT__ if not using BC++, G++, or SC++, as per jnw.
//
// Revision 1.24  1994/12/22  23:35:49  ljr
// Defined __NO_FRIEND_TEMPLATE_SUPPORT for BC++.
//
// Revision 1.23  1994/12/22  23:32:59  ljr
// Defined IA_NEED_CUSTOM_RAND48_H for BC++ and G++.
//
// Revision 1.22  1994/12/13  18:15:24  fjsoria
// and external reference to mktemp C system call
//
// Revision 1.21  1994/12/12  20:20:17  fjsoria
// added __BROKEN_TYPE_CONVERSION for g++
// some simple conversions are not working
// ex. IA_Bit to Int found in Bit.h
//
// Revision 1.20  1994/12/12  15:37:28  fjsoria
// added __NO_FRIEND_TEMPLATE_SUPPORT for image
//
// Revision 1.19  1994/12/08  17:04:12  ljr
// Defined IA_BCPP_CONCAT_OVERLOAD_RESOLUTION for BC++.
//
// Revision 1.18  1994/12/06  18:41:33  gmt
// Added IA_NO_CONSTRUCTOR_ON_RETURN.
//
// Revision 1.17  1994/12/01  15:43:37  fjsoria
// changed misleading gaurd fron NO_INLINE_DESTRUCTORS to
// NO_OOUTLINE_DESTRUCTORS
//
// Revision 1.16  1994/11/10  19:14:15  ljr
// Defined IA_NO_RCS_STATIC_DATA for G++.
//
// Revision 1.15  1994/11/10  18:48:35  ljr
// Defined IA_NO_RCS_STATIC_DATA for BC++.
//
// Revision 1.14  1994/10/31  18:52:11  fjsoria
// added gaurds for #include IntPS DblPs found in Set.h
//
// Revision 1.13  1994/10/17  19:09:02  fjsoria
// added IIPRI
//
// Revision 1.12  1994/10/07  17:21:07  fjsoria
// *** empty log message ***
//
// Revision 1.11  1994/10/03  19:49:31  thoth
// g++ std library has Complex, not complex.
// Symantec has problems with nested types in
// a function signature.
//
// Revision 1.10  1994/09/28  22:35:35  gmt
// Added define "NO_VOLATILE_FUNCTIONS"
//
// Revision 1.9  1994/09/27  19:41:09  fjsoria
// g++ v2.6 does not support non-inlined destructors
// added __NO_INLINE_DESTRUCTORS
//
// Revision 1.8  1994/09/27  01:39:49  gmt
// SC++ does not handle automatic autoinstantiation of static data, so
// define IA_NO_AUTOINST_OF_STATIC_DATA.
//
// Revision 1.7  1994/09/23  15:46:44  thoth
// Functions were in the library, but just weren't in the header files.
//
// Revision 1.6  1994/09/13  21:19:25  fjsoria
// added ansi compatibility for math.h for g++ v2.6
//
// Revision 1.5  1994/09/13  19:07:07  ljr
// changed to #define IA_NO_TEMPS_IN_CONDITIONAL_EXPRS for BC++
//
// Revision 1.4  1994/09/12  23:32:33  thoth
// screwy new symbol for g++ bug.
//
// Revision 1.3  1994/08/17  01:59:51  gmt
// Added log and id comments for RCS stuff.
//

// $Id: compat.h,v 1.27 1994/12/28 21:45:45 ljr Exp $

#ifndef IA_compat_h_
#define IA_compat_h_

/* first section.

   Based on what compiler you have, turn on/off various symbols to
control woejus hack workarounds.

*/

#define NO_INST_TEMPLATE 

#ifdef __GNUC__

#undef NO_INST_TEMPLAT
#define IA_NO_NESTED_ENUMS
#define __NO_OUTLINE_DESTRUCTORS
#define __NO_FRIEND_TEMPLATE_SUPPORT
#define __BROKEN_TYPE_CONVERSION
//#define IA_PRII
#ifdef sun
// g++ still has a few problems

// bloody broken includes
extern "C" {
    double aint(double);
    int nint(double);
    double anint(double);
    int irint(double);
    char *mktemp(char *); // used in UchartDI.c and BitDI.c
}

#endif // sun

#define IA_NO_AUTOINST_OF_STATIC_DATA
class Complex;
typedef Complex complex;	// gotta standardize on something.

#define IA_NO_RCS_STATIC_DATA
#define IA_NEED_CUSTOM_RAND48_H

#endif // __GNUC__

#ifdef __BCPLUSPLUS__
#define IA_NEED_TYPES
#define IA_NEED_AINT
#define IA_NEED_NINT
#define IA_NEED_ANINT
#define IA_NEED_RINT
#define IA_NEED_IRINT
#define IA_NO_TEMPS_IN_CONDITIONAL_EXPRS
#define IA_NO_VOLATILE_FUNCTIONS
#define IA_NO_RCS_STATIC_DATA
#define IA_BCPP_CONCAT_OVERLOAD_RESOLUTION
#define IA_NEED_CUSTOM_RAND48_H
#define __NO_FRIEND_TEMPLATE_SUPPORT
#endif

#ifdef __SC__
#define IA_NEED_TYPES
#define IA_NEED_AINT
#define IA_NEED_NINT
#define IA_NEED_ANINT
#define IA_NEED_RINT
#define IA_NEED_IRINT
#define IA_NO_VOLATILE_FUNCTIONS

#define IA_NO_NESTED_ENUMS

#define IA_NO_CONSTRUCTOR_ON_RETURN

#pragma template_access extern

#define IA_NO_AUTOINST_OF_STATIC_DATA

#endif // __SC__

/*
   Second section.

  Based on symbols defined in the compiler-dependent section above,
perform varios disgusting hacks to work around bustedness in various
compilers.

 */


#ifndef IA_NO_VOLATILE_FUNCTIONS
#define VOL_F
#else
#define VOL_F volatile
#endif

#ifdef IA_NEED_TYPES
typedef unsigned char u_char;
typedef int pid_t;
#else
#include <sys/types.h>
#endif

extern "C" {

#ifdef IA_NEED_AINT
double aint(double x);
#endif

#ifdef IA_NEED_NINT
int nint(double x);
#endif

#ifdef IA_NEED_ANINT
double anint(double x);
#endif

#ifdef IA_NEED_RINT
double rint(double x);
#endif

#ifdef IA_NEED_IRINT
int irint(double x);
#endif

}

#endif // IA_compat_h_
