# Sed script to santize code written for earlier version of the 
# iac++ class library to conform with the version 1.0 naming conventions.
#
# These are listed in reverse order, from most complex to least
# that way the longest possible names should be converted first.
#

###################################################################
# IA_*Template<T> classes
###################################################################
s/IA_BitDDTemplate/IA_DDTemplate<IA_Image<IA_IntPoint, IA_Bit> >/g
s/IA_UcharDDTemplate/IA_DDTemplate<IA_Image<IA_IntPoint, u_char> >/g
s/IA_IntDDTemplate/IA_DDTemplate<IA_Image<IA_IntPoint, int> >/g
s/IA_FloatDDTemplate/IA_DDTemplate<IA_Image<IA_IntPoint, float> >/g
s/IA_ComplexDDTemplate/IA_DDTemplate<IA_Image<IA_IntPoint, complex> >/g

###################################################################
# IA_*DiscreteImage classes
###################################################################
s/IA_BitDiscreteImage/IA_Image<IA_Point<int>,IA_Bit>/g
s/IA_ComplexDiscreteImage/IA_Image<IA_Point<int>,complex>/g
s/IA_FloatDiscreteImage/IA_Image<IA_Point<int>,float>/g
s/IA_IntDiscreteImage/IA_Image<IA_Point<int>,int>/g
s/IA_RGBDiscreteImage/IA_Image<IA_Point<int>,IA_RGB>/g
s/IA_UcharDiscreteImage/IA_Image<IA_Point<int>,u_char>/g

###################################################################
# IA_*ContiniousImage class
###################################################################
s/IA_FloatContinuousImage/IA_Image<IA_Point<int>,float>/g

###################################################################
# IA_ Image Iterator classes
###################################################################
s/IA_DIVIter/IA_IVIter<IA_Point<int>,#imagetype#>/g
s/IA_DIPIter/IA_IPIter<IA_Point<int>,#imagetype#>/g


###################################################################
# IA_ValueSet<T> classes
###################################################################


###################################################################
# IA_*PointSet  classes
###################################################################
s/IA_IntPointSet/IA_Set<IA_Point<int> >/g
s/IA_FloatPointSet/IA_Set<IA_Point<double> >/g

s/IA_IPSIter/IA_PSIter<IA_Point<int> >/g


###################################################################
# IA_*Point  classes
###################################################################
s/IA_IntPoint/IA_Point<int>/g
s/IA_FloatPoint/IA_Point<double>/g


###################################################################
# ia.h  miscellenous
###################################################################
s/IA::exit_on_throw/IA::abort_on_throw/g
s/IA::exit_on_index_uncontained/IA::throw_on_index_uncontained/g
