// image_example.05.c   Image composition with point-to-point function

#include "UcharDI.h"
#include "FloatCI.h"
#include "BLInterp.h"


// Instances of class rot  represent functions that rotate an
//    IA_Point<double>   through a fixed rotation.
// NOTE: the angle of rotation is defined at instance
//    creation time.  Hence different instances of class  rot
//    may represent different rotation functions.

class rot : public IA_Closure<IA_Point<double> , IA_Point<double> > {
    const double	S,C;
  public:
    rot(double	theta)
    :S(sin(theta)), C(cos(theta)) { }
    IA_Closure<IA_Point<double> , IA_Point<double> >* clone_self() const {
	return new rot(*this);
    }
    IA_Point<double>  operator()(const IA_Point<double>  &p) const {
	return IA_Point<double> (p[0]*C + p[1]*S, p[1]*C-p[0]*S);
    }
};


int main()
{
    IA_Image<IA_Point<int>,u_char>
	im1 = read_uchar_PGM(cin);

    IA_Image<IA_Point<double>,float>
	im2(IA_BLInterp<float>(IA_Image<IA_Point<int>,float>(im1)));


    // Rotate 40 degrees
    im2 = IA_Image<IA_Point<double>,float>(
	compose(im2, rot(M_PI*40.0/180))
	);
 

    IA_Image<IA_Point<int>,u_char>
	udi(to_uchar(im2.restrict(im1.domain())));

    display( udi );

    return 0;
}
