// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: pointset_errors.h,v $
// Revision 1.3  1994/05/08  19:37:45  thoth
// New intpointset decomposition capability.
//
// Revision 1.2  1994/04/15  13:11:53  thoth
// Added new exception to go with new array constructor.
//
// Revision 1.1  1994/02/01  13:52:46  thoth
// Initial revision
//

#ifndef pointset_errors_h_
#define pointset_errors_h_

struct Pointset_BadTranspose_Exception : public GenericException {
  Pointset_BadTranspose_Exception(const char *fn, int l)
    :GenericException
      ("Pointset: attempt to transpose a non-boxy or non-2-D pointset", fn, l) {}
};

struct Pointset_EmptyPointArray_Exception : public GenericException {
    Pointset_EmptyPointArray_Exception(const char *fn, int l)
	:GenericException
	    ("Pointset: attempt to build pointset from empty point array;  no way to compute dimension", fn, l) { }
};

struct Pointset_DecompFragBounds_Exception : public GenericException {
  Pointset_DecompFragBounds_Exception(const char *fn, int l)
    :GenericException
	    ("Pointset: Attempt to access non-existent frag from decomposition.  Index out of bounds", fn, l) { }
};
#endif // pointset_errors_h_
