// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log: HashTable.h,v $
// Revision 1.9  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.8  1993/05/26  16:51:26  thoth
// Copyright Notices
//
// Revision 1.7  93/04/19  23:27:39  thoth
// Convert BaseIPS to IA_BasePS<IA_IntPoint>
// 
// Revision 1.6  93/02/12  16:21:24  thoth
// more comments
// 
// Revision 1.5  93/01/20  11:35:41  thoth
// increase in hash table size should result in slight performance improvement
// 
// Revision 1.4  92/12/16  14:48:04  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.3  92/08/23  13:30:07  thoth
// CFrontified version
// 
// 

#ifndef HashTable_h_
#define HashTable_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BasePS.h"
#include "IntPoint.h"

const int TBLSIZE=4095;

// HType must be a pointer
typedef IA_BasePS<IA_Point<int> >	*HType;

// a hash table that handles overflows with a linked list

class IA_HashTable {
private:
  struct link {
      link	*next;
      HType	data;
  };
  link *buckets[TBLSIZE];

public:
  IA_HashTable();
  ~IA_HashTable();
  int reference(HType in, HType *out);
/*
  passing in==0 is illegal.

  reference will search the hash table for an HType that is ->equal()
to in.  If it finds one it will store it in out and reference will
return 1.  Otherwise out will be set to in, the pointer will be stored
in the hash table and reference will return 0.

  in and out must be different variables for cleanup to be proper.

  idiom:
  if (reference(ptr, temp)) {
      delete ptr;
  }
  ... use temp
  */


  void remove(HType);
  // remove removes an entry from the hash table
};

#endif
