// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: UcharDDTempl.h,v $
// Revision 1.5  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.1  1993/09/15  12:56:58  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:22:41  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/26  17:02:59  thoth
// constructors that specify pointsets aren't supported right now.
// 
// Revision 1.1  93/03/18  11:15:39  thoth
// Initial revision
// 

#ifndef UcharDDTempl_h_
#define UcharDDTempl_h_

#include "DDTempl.h"
#include "UcharDI.h"

class IA_UcharDDTemplate: public IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > {
  public:
//    IA_UcharDDTemplate(const IA_Set<IA_Point<int> > &ps,
//		       const IA_Image<IA_Point<int>,u_char> im)
//    :IA_DDTemplate<IA_Image<IA_Point<int>,u_char> >(ps, im) { }

    IA_UcharDDTemplate(unsigned dim, const IA_Image<IA_Point<int>,u_char> im)
    :IA_DDTemplate<IA_Image<IA_Point<int>,u_char> >(IA_WhiteHole(dim), im) { }

    IA_UcharDDTemplate(const IA_ClosureDT< IA_Image<IA_Point<int>,u_char> > &o)
    :IA_DDTemplate<IA_Image<IA_Point<int>,u_char> >(o) { }

//    IA_UcharDDTemplate(const IA_Set<IA_Point<int> > &ps,
//		       IA_Image<IA_Point<int>,u_char> (*f)(const IA_Point<int>&))
//    :IA_DDTemplate<IA_Image<IA_Point<int>,u_char> >(ps, f) { }
    IA_UcharDDTemplate(unsigned dim,
		       IA_Image<IA_Point<int>,u_char> (*f)(const IA_Point<int>&))
    :IA_DDTemplate<IA_Image<IA_Point<int>,u_char> >(IA_WhiteHole(dim), f) { }
#include	"UcharConv.h"
};

#endif
