// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ImgComp.h,v $
// Revision 1.1  1994/09/16  18:24:34  thoth
// Initial revision
//

#ifndef ImgComp_h_
#define ImgComp_h_

#include "Closure.h"
#include "CoreImage.h"

// value composition
template <class P, class Q, class R, class S, class T>
IA_CoreImage<P,Q> compose(R (*)(S), const IA_CoreImage<P,T> &, const Q*, const R*, const S*);

template <class P, class R, class S, class T>
inline IA_CoreImage<P,R> compose(R (*f)(S), const IA_CoreImage<P,T> &i, const R*, const S*) { return compose(f, i, (const R*)0, (const R*)0, (const S*)0); }

template <class P, class S, class T>
inline IA_CoreImage<P,S> compose(S (*f)(T), const IA_CoreImage<P,T> &i, const S*) { return compose(f, i, (const S*)0, (const S*)0, (const T*)0); }

template <class P, class T>
inline IA_CoreImage<P,T> compose(T (*f)(T), const IA_CoreImage<P,T> &i) { return compose(f, i, (const T*)0, (const T*)0, (const T*)0); }




template <class P, class Q, class R, class S, class T>
IA_CoreImage<P,Q> compose(const IA_Closure<S,R>&, const IA_CoreImage<P,T> &, const Q*);

template <class P, class R, class S, class T>
inline IA_CoreImage<P,R> compose(const IA_Closure<S,R>&f, const IA_CoreImage<P,T> &i) { return compose(f, i, (const R*)0); }

#endif // ImgComp_h_
