// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: CplxDDTempl.h,v $
// Revision 1.4  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.3  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
// 

#ifndef ComplexDDTempl_h_
#define ComplexDDTempl_h_

#include "DDTempl.h"
#include "CplxDI.h"

class IA_ComplexDDTemplate: public IA_DDTemplate<IA_Image<IA_Point<int>,complex> > {
  public:

    IA_ComplexDDTemplate(unsigned dim, const IA_Image<IA_Point<int>,complex> im)
    :IA_DDTemplate<IA_Image<IA_Point<int>,complex> >(IA_WhiteHole(dim), im) { }

    IA_ComplexDDTemplate(const IA_ClosureDT< IA_Image<IA_Point<int>,complex> > &o)
    :IA_DDTemplate<IA_Image<IA_Point<int>,complex> >(o) { }

    IA_ComplexDDTemplate(unsigned dim,
		       IA_Image<IA_Point<int>,complex> (*f)(const IA_Point<int>&))
    :IA_DDTemplate<IA_Image<IA_Point<int>,complex> >(IA_WhiteHole(dim), f) { }
#include	"CplxConv.h"
};

#endif
