// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: closure.c,v $
// Revision 1.14  1994/08/22  15:12:29  thoth
// derangement had been redone.  New placebo installed.
//
// Revision 1.13  1994/08/18  23:39:28  thoth
// DOS-inspired filename rework
//
// Revision 1.12  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.11  1994/05/08  19:37:45  thoth
// New intpointset decomposition capability.
//
// Revision 1.10  1994/03/14  15:40:13  thoth
// ValueSet is no longer public.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

#include "ClosurePS.h"
#include "IntPoint.h"
#include "DblPoint.h"
#include "../valueset/ValueSet.h"
#include "IntPS.h"
#include "PSIter.h"

template <class P>
class empty_ps:public IA_ClosurePS<P> {
  public:
    IA_ClosurePS<P> *clone_self() const;
    int contains(const P &ip) const;
    empty_ps(unsigned dim) :IA_ClosurePS<P>(dim) {};
};

template <class P>
IA_ClosurePS<P> *empty_ps<P>::clone_self() const
{
    return new empty_ps<P>(dimen);
}

template <class P>
int empty_ps<P>::contains(const P &) const
{
    return 0;
}

empty_ps<IA_Point<int> >	tempI(2);
empty_ps<IA_Point<double> >	tempF(2);

void exercise(const IA_Set<IA_Point<int> > &ps)
{
    IA_PSIter<IA_Point<int> >	iter1,
				iter2(ps);
    IA_PSIter<IA_Point<int> >	iter3(iter1);

    iter1 = iter2;
    iter3 = iter2.domain();

    IA_Point<int> ip;
    if (iter1(ip))
	iter1.reset();

    IA_SetStructure	ss1;
    IA_SetStructure	ss2(ss1);
    ss1 = ss2;
    (void)(ss1 == ss2);
    (void)(ss1 != ss2);
    ss1.add_interval(0, ss1);
    ss1.retrieve_interval(0);
    ss1.nintervals();
    ss1.ensure_space(0);
    

    IA_PointSetDecomposition	psd;
    IA_PointSetDecomposition	psd2(psd);
    psd2 = psd;
    IA_decomp_frag	whatever;
    whatever = whatever;
    whatever = psd.get_frag(0);
}


void exercise(const IA_Set<IA_Point<double> > &ps)
{
    IA_PSIter<IA_Point<double> >	iter1,
	iter2(ps);
    IA_PSIter<IA_Point<double> >	iter3(iter1);

    iter1 = iter2;
    iter3 = iter2.domain();

    IA_Point<double> ip;
    if (iter1(ip))
	iter1.reset();
}


// placate the stupid ptlink

IA_ValueSet<IA_Point<double> >::IA_ValueSet(IA_Point<double>) { }

IA_ValueSet<IA_Point<double> >::IA_ValueSet(const IA_Point<double>*, unsigned) { }


int IA_ValueSet<IA_Point<double> >::contains(IA_Point<double>) const {
  return 0;
}

char IA_ValueSet<int>::dummy;


ostream &operator<<(ostream &o, const IA_Point<int>&) {
  return o;
}

ostream &operator<<(ostream &o, const IA_ValueSet<IA_Point<double> >&) {
  return o;
};


//
//
//

int pointcmp(const IA_Point<int>&, const IA_Point<int>&) {
  return 0;
}
int pointcmp(const IA_Point<double>&, const IA_Point<double>&) {
  return 0;
}

IA_Point<double>::IA_Point(const IA_Point<double>&) { }
IA_Point<double>& IA_Point<double>::operator= (const IA_Point<double>&) { return *this; }

IA_Point<int> IA_Point<int>:: operator+(const IA_Point<int>&) const { return IA_Point<int>(); }
IA_Point<int> IA_Point<int>:: operator-(const IA_Point<int>&) const { return IA_Point<int>(); }
int IA_Point<int>::operator==(const IA_Point<int>&) const { return 0; }
int IA_Point<int>::operator<=(const IA_Point<int>&) const { return 0; }

IA_Point<int> inf(const IA_Point<int>&, const IA_Point<int>&) { return IA_Point<int>(); }
IA_Point<int> sup(const IA_Point<int>&, const IA_Point<int>&) { return IA_Point<int>(); }
IA_Point<int>::IA_Point(const IA_Point<int>&) { }
IA_Point<int>& IA_Point<int>::operator= (const IA_Point<int>&) { return *this; }

IA_Point<int> cdr(const IA_Point<int>&, int) { return IA_Point<int>(); }
IA_Point<int>::IA_Point(int*, unsigned, int) {}
IA_Point<int> concat(int, const IA_Point<int>&) { return IA_Point<int>(); }

IA_Point<int> derange(const IA_Point<int> &p,unsigned, unsigned) {
    return p;
}

void ia_throw(IA::Error, char*, int) { }

