// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char rcsid[] = "$Id: BoxyIPSIter.c,v 1.7 1994/07/25 16:58:52 thoth Exp $";

// 
// $Log: BoxyIPSIter.c,v $
// Revision 1.7  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.6  1993/07/15  11:38:59  thoth
// new BasePSIter implementation.
//
// Revision 1.5  93/05/28  15:05:24  thoth
// removed dependency on with-ia-pointset*
// 
// Revision 1.4  93/05/26  16:41:05  thoth
// Copyright Notices.
// 
// Revision 1.3  93/04/16  15:50:14  thoth
// use IA_IntPoint instead of IntPoint.
// 
// Revision 1.2  92/12/16  14:48:00  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.1  92/08/23  13:30:00  thoth
// Initial revision
// 
// 

#include "BoxyIPSIter.h"

#ifdef IA_PRII
#pragma implementation
#endif

IA_BoxyIPSIter::IA_BoxyIPSIter(IA_BoxyIPS *b)
: IA_BasePSIter<IA_Point<int> >(b),
  curr(b->start)
{
}

IA_BoxyIPSIter::IA_BoxyIPSIter(const IA_BoxyIPSIter &x)
: IA_BasePSIter<IA_Point<int> >(x.domain),
  curr(x.curr)
{
}

int IA_BoxyIPSIter::next(IA_Point<int>& ip)
{
    // This only happens if the previous call to next caused
    // curr to carry past its beginning (which means we ran out of points).
    if (this->curr[0] > box()->end[0])
	return 0;

    // prepare the parameter for when we return;
    ip = this->curr;

    // increment curr to the lexicographically next point in the point set.
    unsigned i = box()->dimen - 1;
    while (1) {
	if (++this->curr[i] > box()->end[i] && i!=0) {
	    // We have overflowed the current "digit".
	    // Reset this digit and allow the loop to run around for
	    // the carry.
	    this->curr[i] = box()->start[i];
	} else {
	    // Either there is no overflow or we have run out of digits to
	    // carry into.  We can provide the user with a point in any case.

	    break;

	    // on the next call to the next() method, an overflow will
	    // be detected.
	}
	// There was an overflow.  We will loop again using the next
	// higher significant digit.
	i--;
    }

    // Whatever happened during the increment operation doesn't matter here.
    // we knew we had a value to return when we realized curr was in bounds.
    // If the increment operation totally overflowed, then the next call
    // to next() will be unable to provide a point and the test at the
    // beginning will handle it appropriately.
    return 1;
}
