// -*- C++ -*-
//      Copyright 1993, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

#ifndef IA_Stack_h_
#define IA_Stack_h_

#include "Deque.h"

static char IA_Stack_h_rcsid[] = "$Id: Stack.h,v 1.1 1994/04/27 18:26:09 rjj Exp $";

// $Log: Stack.h,v $
 * Revision 1.1  1994/04/27  18:26:09  rjj
 * Initial revision
 *


template <class T>
class IA_Stack: protected IA_Deque<T> {
private:
    void nullStack();

protected:
    
public:

    IA_Stack();

    IA_Stack(const IA_Stack<T>&); // yielding a copy of the IA_Stack
    IA_Stack(T *, unsigned);      // where size = number of elements in vec

    IA_Stack(T v0);               //constructing IA_Stack with one element
    IA_Stack(T v0, T v1);
    IA_Stack(T v0, T v1, T v2);
    IA_Stack(T v0, T v1, T v2, T v3);
    IA_Stack(T v0, T v1, T v2, T v3, T v4);

    virtual ~IA_Stack();

    IA_Stack<T>&  operator=  (const IA_Stack<T>&);

    T             operator() (unsigned) const;
    T&            operator[] (unsigned);

    int      empty()  const;  // Is the IA_Stack empty? 
    unsigned length() const;  // The number of elements in the stack

    T        top() const;     // The top element in the stack
    void     push(T);         // Push the value onto the stack
    void     pop(T&);         // Pop the top element off the stack
};

#endif
