// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log: VectorImageIter.h,v $
// Revision 1.2  1993/11/17  18:29:31  thoth
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  12:58:01  thoth
// Initial revision
//

#ifndef VectorImageIter_h_
#define VectorImageIter_h_

#include <stdlib.h>
#include "PSIter.h"
#include "BaseImageIter.h"
#include "VectorI.h"

template < class P,class T>
class IA_VectorIVIter: public IA_BaseIVIter<P,T> {
protected:
    // num_left stores the number of points in this image\'s PointSet
    // remaining to be iterated.
    int num_left;

    // index stores the index of the current point within the value vector
    int index;

    // vip points at the base image over which we're iterating.
    IA_VectorI<P,T> *vip() const { return (IA_VectorI<P,T> *)domain; }

public:

    IA_VectorIVIter(const IA_VectorI<P,T> *);
    IA_VectorIVIter(const IA_VectorIVIter&);

    ~IA_VectorIVIter() {}

    IA_BaseIVIter<P,T> * clone_self() { return new IA_VectorIVIter(*this); }
    int next(T&);
    void reset() { this->num_left = this->domain->domain().card();
		   this->index =0; }

    IA_BaseImage<P,T> *domain_() const { return this->domain; }
};

template < class P,class T>
class IA_VectorIPIter: public IA_BaseIPIter<P,T> {
protected:
    // index stores the index of the current point within the value vector
    int index;

    // vip points at the base image over which we're iterating.
    IA_VectorI<P,T> *vip() const { return (IA_VectorI<P,T> *)domain; }

    // psiter is an iterator over bdip's PointSet.
    IA_PSIter<P> psiter;

public:

    IA_VectorIPIter(const IA_VectorI<P,T> *);
    IA_VectorIPIter(const IA_VectorIPIter&);

    ~IA_VectorIPIter() {}

    IA_BaseIPIter<P,T> * clone_self() { return new IA_VectorIPIter(*this); }

    int next(P&, T&);

    void reset() { psiter.reset(); this->index = 0;}

    IA_BaseImage<P,T> *domain_() const { return this->domain; }
};

#endif
