// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: LazyXlationI.h,v $
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1993/11/29  22:24:52  thoth
// Initial revision
//

#ifndef LazyXlationI_h_
#define LazyXlationI_h_

#include <iostream.h>
#include "BaseI.h"

template < class P,class T>
class IA_LazyXlationI: public IA_BaseImage<P,T> {
  private:
    static char	dummy;

    const P	offset;
    IA_BaseImage<P,T>	* base;
  public:
    IA_LazyXlationI(const IA_BaseImage<P,T> *base_, P offset_)
    :IA_BaseImage<P,T>(base_->domain() + offset_)
#if 1
	, offset(offset_)
	, base((IA_BaseImage<P,T>*)base_) 
#endif
    {
#if 0
	*(P*)&offset = offset_;
	base = (IA_BaseImage<P,T>*)base_;
#endif
	base->incr_ref();
    }
    ~IA_LazyXlationI() {
	if (base->decr_ref()<=0)
	    delete base;
    }
    int extensive() const { return 0; }
    T operator() (const P &p) const {
	return (*base)(p-offset);
    }
    IA::Type type() const { return &dummy; }
    IA_BaseImage<P,T> * xlated_by(const P &p) const {
	return new IA_LazyXlationI<P,T>(base, p+offset);
    }
    ostream& print_this(ostream&o) const {
	o<< "translation by " << offset << " of \n";
	return base->print_this(o);
    }
};

template < class P,class T>
char IA_LazyXlationI<P,T>::dummy;

#endif // LazyXlationI_h_
