#ifndef IA_LazyInvConv_h_
#define IA_LazyInvConv_h_

template <class I, I(*f)(const I&,const IA_DDTemplate<I>&)>
struct IA_lazy_inv : public IA_InvariantDT<I> {
  private:
    static char dummy;

public:
    IA_DDTemplate<I>	lhs, rhs;

public:
    IA_lazy_inv(const IA_Set<IA_Point<int> > &ps,
		     const IA_DDTemplate<I> &lhs_,
		     const IA_DDTemplate<I> &rhs_)
	: IA_InvariantDT<I>(ps, f(lhs_(0), rhs_,
				  lhs_(0).domain() + rhs_(0).domain())),
    lhs(lhs_), rhs(rhs_) {
    }

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }
    int is_a(IA::Type t) { return (t == type()
				   || ((IA_InvariantDT<I>&)this).is_a(t)) ; }
};

#endif // IA_LazyInvConv_h_
