// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FuncDT.h,v $
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/02/22  18:46:25  thoth
// New is_a virtual method, used to determine if an object is of a
// class derived from another class.
//
// Revision 1.2  1994/02/12  19:34:43  thoth
// Using IA::Type instead of the IA_DiscreteImageType typedef.
//
// Revision 1.1  1993/09/15  12:53:28  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:22:14  thoth
// Copyright Notices
// 
// Revision 1.1  93/04/17  19:00:38  thoth
// Initial revision
// 


#ifndef FunctionDT_h_
#define FunctionDT_h_

#include "ia.h"
#include "BaseDT.h"

template <class I>
class IA_FunctionDT: public IA_BaseDT<I>{
private:
    I (*func)(const IA_Point<int>&);

    static char dummy;
public:
    IA_FunctionDT(const IA_Set<IA_Point<int> >& p, I (*fp)(const IA_Point<int>&))
    : IA_BaseDT<I>(p){
	this->func = fp;
    }

    I operator ()(const IA_Point<int>&) const;

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }
    int is_a(IA::Type t) { return t == s_type() ; }

    ostream& print_this(ostream&) const;
};

#endif
