// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FloatDDTempl.h,v $
// Revision 1.5  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.1  1993/09/15  12:52:24  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:21:42  thoth
// Copyright Notices
// 
// Revision 1.1  93/05/26  17:16:03  thoth
// Initial revision
// 
// Revision 1.1  93/03/18  11:15:39  thoth
// Initial revision
// 

#ifndef FloatDDTempl_h_
#define FloatDDTempl_h_

#include "DDTempl.h"
#include "FloatDI.h"

class IA_FloatDDTemplate: public IA_DDTemplate<IA_Image<IA_Point<int>,float> > {
  public:
//    IA_FloatDDTemplate(const IA_Set<IA_Point<int> > &ps,
//		       const IA_Image<IA_Point<int>,float>  im)
//    :IA_DDTemplate<IA_Image<IA_Point<int>,float> >(ps, im) { }

    IA_FloatDDTemplate(unsigned dim, const IA_Image<IA_Point<int>,float>  im)
    :IA_DDTemplate<IA_Image<IA_Point<int>,float> >(IA_WhiteHole(dim), im) { }

    IA_FloatDDTemplate(const IA_ClosureDT< IA_Image<IA_Point<int>,float>  > &o)
    :IA_DDTemplate<IA_Image<IA_Point<int>,float> >(o) { }

//    IA_FloatDDTemplate(const IA_Set<IA_Point<int> > &ps,
//		       IA_Image<IA_Point<int>,float>  (*f)(const IA_Point<int>&))
//    :IA_DDTemplate<IA_Image<IA_Point<int>,float> >(ps, f) { }
    IA_FloatDDTemplate(unsigned dim,
		       IA_Image<IA_Point<int>,float>  (*f)(const IA_Point<int>&))
    :IA_DDTemplate<IA_Image<IA_Point<int>,float> >(IA_WhiteHole(dim), f) { }
#include	"FloatConv.h"
};

#endif
