// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ErrorI.h,v $
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/03/14  15:48:33  thoth
// ValueSet has been replaced by container class Set.
//
// Revision 1.2  1993/11/17  18:14:21  thoth
// extensivep is now extensive.
// The empty ValueSet is not initialized by 0.
//
// Revision 1.1  1993/09/15  12:52:03  thoth
// Initial revision
//

#ifndef ErrorDI_h_
#define ErrorDI_h_

#include <stdlib.h>
#include "BaseI.h"

// ErrorI generates members of a class of BaseImages whose only valid operation
// is decr_ref().  This is used to trap operations occurring upon
// uninitialized images.

template < class P,class T>
class IA_ErrorI:public IA_BaseImage<P,T> {

public:

    IA_ErrorI() :IA_BaseImage<P,T>(IA_Set<P>()) { }

    int extensive() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return 0;
    }

    T operator ()(const P &) const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }

    T& operator [](const P &) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }

#if 0
    T& operator [](int) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }

    T operator ()(int) const {
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }
#endif

    static IA::Type s_type() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return 0;
    }

    IA::Type type() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return 0;
    }

    IA_Set<P> domain() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return this->ps;
    }

    IA_Set<T> range() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return IA_Set<T>();
    }

    // ~IA_ErrorI() { } // gratuitous

    IA_BaseImage<P,T>* clone_self_extensively() const {
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return (IA_BaseImage<P,T> *)this;
    }

    virtual ostream& print_this(ostream& o) const {
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return o;
    }
    
};

#endif
