/*  $RCS$
    $Log: valueset-utils.c,v $
 * Revision 1.5  1992/12/14  16:19:13  jm
 *  Renamed class ValueSet to IA_ValueSet
 *
 * Revision 1.4  92/09/29  15:29:51  jm
 * *** empty log message ***
 * 
 * Revision 1.3  92/09/16  17:15:24  jm
 * *** empty log message ***
 * 
 * Revision 1.2  92/09/16  17:01:40  jm
 * *** empty log message ***
 * 
*/

#include "ValueSet.h"

template <class ValueType>
ValueType make_random_value(ValueType bot, int top ) {

    int   range;
    int bottom = (int) bot;
    
    if (top < bottom) {
        int temp = top;
        top = bottom;
        bottom = temp;
    }
    range = top - bottom + 1;
    
#define randlong()      lrand48()
    
    return (ValueType) (bottom +  randlong() % range);
}

template <class ValueType>
ostream& operator<< (ostream& st, IA_ValueSet<ValueType>& vs) {
    int last_index = vs.size-1;
    st << "<"; 
    if (vs.size > 0) {
	for (int i=0; i < last_index; i++)
	    st << vs.value_array[i] << " ";
	if (vs.size > 0)
	    st << vs.value_array[last_index];
    }
    st << ">" << '\n';
    return st;
}

template <class ValueType>
void op(ostream& os, const IA_ValueSet<ValueType>& vs) {
    IA_ValueSetIter<ValueType> next(vs);
    ValueType x;

    os << "< ";
    while (next(x))
	os << x << " ";
    os << ">\n";
}
