// Emacs: -*- C++ -*-

static char rcsid[] = "$Id: test-min.C,v 1.1 1992/08/20 22:26:32 rjj Exp $";

//
// $Log: test-min.C,v $
// Revision 1.1  1992/08/20  22:26:32  rjj
// Initial revision
//
// 
// 

#include <IntPoint.h>
#include <FloatPoint.h>

int main(int argc, char**argv)
{
    IntPoint	ip(0, 1, -2, -1), iq(3, 2, 1, 0);
    FloatPoint	fp(0.0, 0.1, -0.2, -0.1), fq(0.3, 0.2, 0.1, 0.0);
    
    IA::exit_on_throw = 0;
    
    cout << "ip: " << ip << "\n";
    cout << "iq: " << iq << "\n";
    cout << "fp: " << fp << "\n";
    cout << "fq: " << fq << "\n";

    cout << "min(ip, iq): " << min(ip, iq) << "\n";
    cout << "min(iq, ip): " << min(iq, ip) << "\n";
    cout << "max(ip, iq): " << max(ip, iq) << "\n";
    cout << "max(iq, ip): " << max(iq, ip) << "\n";

    cout << "min(fp, fq): " << min(fp, fq) << "\n";
    cout << "min(fq, fp): " << min(fq, fp) << "\n";
    cout << "max(fp, fq): " << max(fp, fq) << "\n";
    cout << "max(fq, fp): " << max(fq, fp) << "\n";

    cout << "min(ip, fp): " << min(ip, fp) << "\n";
    cout << "min(fp, ip): " << min(fp, ip) << "\n";
    cout << "max(ip, fp): " << max(ip, fp) << "\n";
    cout << "max(fp, ip): " << max(fp, ip) << "\n";

    cout << "min(ip): " << min(ip) << "\n";
    cout << "min(iq): " << min(iq) << "\n";
    cout << "max(ip): " << max(ip) << "\n";
    cout << "max(iq): " << max(iq) << "\n";

    cout << "min(fp): " << min(fp) << "\n";
    cout << "min(fq): " << min(fq) << "\n";
    cout << "max(fp): " << max(fp) << "\n";
    cout << "max(fq): " << max(fq) << "\n";

    cout << "min(ip): " << min(ip) << "\n";
    cout << "min(fp): " << min(fp) << "\n";
    cout << "max(ip): " << max(ip) << "\n";
    cout << "max(fp): " << max(fp) << "\n";
}
