// Emacs: -*- C++ -*-

// 
// $Log:	generic-tests.h,v $
// Revision 1.9  92/12/16  14:48:31  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.8  92/11/11  12:12:33  thoth
// test of another restriction utility.
// 
// Revision 1.7  92/11/04  12:02:54  thoth
// test of new image extension support routines.
// 
// Revision 1.6  92/10/21  15:00:04  thoth
// added test for image restriction utility.
// 
// Revision 1.5  92/09/20  17:42:40  thoth
// added minkowski test.
// 
// Revision 1.4  92/09/07  13:25:22  thoth
// new test for the IntPoint array constructor
// 
// Revision 1.3  92/08/25  15:38:28  thoth
// new test for translation verification
// 
// Revision 1.2  92/08/23  13:30:29  thoth
// CFrontified version
// 
//

#ifndef generic_tests_h_
#define generic_tests_h_

#include "with-ia-pointset.h"

void test_union(IntPointSet a, IntPointSet b, IntPointSet ab);
void test_intersection(IntPointSet a, IntPointSet b, IntPointSet ab);
void test_XOR(IntPointSet a, IntPointSet b, IntPointSet ab);
void test_minus(IntPointSet a, IntPointSet b, IntPointSet ab);

void test_restriction(IntPointSet a, IntPointSet b);
void test_dualrestriction(IntPointSet a, IntPointSet b);
void test_extension(IntPointSet a, IntPointSet b);

void test_offset(IntPointSet a, IntPoint x, IntPointSet ax);
void test_minkowski(IntPointSet a, IntPointSet b, IntPointSet ab);

void test_arr_ps(IntPointSet ps, const IntPoint *arr, unsigned len);

void list_ips(ostream &, IntPointSet);
void printIntSet(IntPointSet ips);
void test_iter(IntPointSet ps);

#endif
