// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char rcsid[] = "$Id: LazyPS.c,v 1.9 1993/11/17 18:05:34 thoth Exp $";

// 
// $Log: LazyPS.c,v $
// Revision 1.9  1993/11/17  18:05:34  thoth
// PSIter.h is not necessary.
//
// Revision 1.8  1993/06/10  17:15:09  thoth
// typo.
//
// Revision 1.7  93/05/26  16:51:31  thoth
// Copyright Notices
// 
// Revision 1.6  93/04/16  15:50:22  thoth
// use IA_IntPoint instead of IntPoint.
// 
// Revision 1.5  92/12/16  14:48:13  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.4  92/09/30  10:37:13  thoth
// Lazies are now templatized.
// contains now accepts const Point<>&.
// type() system now based on address of static data member.
// 
// Revision 1.3  92/09/20  17:40:57  thoth
// lazy Minkowski point set now works.
// 
// Revision 1.2  92/09/07  13:23:49  thoth
// Lazies now have code to output themselves.
// 
// Revision 1.1  92/09/03  13:37:07  thoth
// Initial revision
// 
//

#include "LazyPS.h"
//#include "PSIter.h"

#ifdef IA_PRII
#pragma implementation
#endif

template <class P>
char IA_PredicatePS_V<P>::type_;

template <class P>
void IA_PredicatePS_V<P>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "pred(" << pred << ")\n";
}

template <class P>
char IA_PredicatePS_CR<P>::type_;

template <class P>
void IA_PredicatePS_CR<P>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "pred(" << pred << ")C&\n";
}

//
//
//

template <class PS_t,class P_t>
char IA_LazyUnionPS<PS_t,P_t>::type_;

template <class PS_t,class P_t>
void IA_LazyUnionPS<PS_t,P_t>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "union of (\n";
    lhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ") with (\n";
    rhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ")\n";
}

template <class PS_t,class P_t>
char IA_LazyIntersectionPS<PS_t,P_t>::type_;

template <class PS_t,class P_t>
void IA_LazyIntersectionPS<PS_t,P_t>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "intersection of (\n";
    lhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ") and (\n";
    rhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ")\n";
}

template <class PS_t,class P_t>
char IA_LazyXORPS<PS_t,P_t>::type_;

template <class PS_t,class P_t>
void IA_LazyXORPS<PS_t,P_t>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "symmetric difference between (\n";
    lhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ") and (\n";
    rhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ")\n";
}

template <class PS_t,class P_t>
char IA_LazyMinusPS<PS_t,P_t>::type_;

template <class PS_t,class P_t>
void IA_LazyMinusPS<PS_t,P_t>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "difference of (\n";
    lhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ") without (\n";
    rhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ")\n";
}

template <class PSI_t,class PS_t,class P_t>
char IA_LazyMinkowskiPS<PSI_t,PS_t,P_t>::type_;

template <class PSI_t,class PS_t,class P_t>
int IA_LazyMinkowskiPS<PSI_t,PS_t,P_t>::contains(const IA_IntPoint &ip) const
{
    PSI_t	iter(ext());
    P_t		op;

    while (iter(op)) {
	if (comp().contains(ip-op))
	    return 1;
    }
    // we didn't find it
    return 0;
}

template <class PSI_t,class PS_t,class P_t>
void IA_LazyMinkowskiPS<PSI_t,PS_t,P_t>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "Minkowski between (\n";
    lhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ") and (\n";
    rhs.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ")\n";
}

//
//
//

template <class PS_t,class P_t>
char IA_LazyNotPS<PS_t,P_t>::type_;

template <class PS_t,class P_t>
void IA_LazyNotPS<PS_t,P_t>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "NOT\n";
    arg.output(o,indent+2);
}

template <class PS_t,class P_t>
char IA_LazyOffsettedPS<PS_t,P_t>::type_;

template <class PS_t,class P_t>
void IA_LazyOffsettedPS<PS_t,P_t>::output(ostream &o, unsigned indent) const
{
    for (unsigned i=0; i<indent; i++)
	o<<' ';
    o << "offset (\n";
    arg.output(o,indent+2);
    for (i=0; i<indent; i++)
	o<<' ';
    o << ") by " << offset << "\n";
}
