// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log:	IPSIter.h,v $
// Revision 1.9  93/05/26  16:51:28  thoth
// Copyright Notices
// 
// Revision 1.8  93/04/17  14:52:56  thoth
// Use IA_IntPoint instead of IntPoint
// 
// Revision 1.7  93/02/12  16:25:23  thoth
// more IA_ prefixes.
// more comments.
// 
// Revision 1.6  92/12/16  14:48:07  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.5  92/12/07  12:07:56  thoth
// the domain method is now const (like it should be)
// 
// Revision 1.4  92/08/23  13:30:11  thoth
// CFrontified version
// 
// 

#ifndef IPSIter_h_
#define IPSIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BaseIPSIter.h"
#include "IntPointSet.h"

class IA_IPSIter {
protected:
  IA_BaseIPSIter	*iter;

  static IA_BaseIPSIter * make_iter(const IA_IntPointSet&);
public:
  IA_IPSIter() { iter = make_iter(IA_BlackHole(0)); }
  IA_IPSIter(const IA_IntPointSet &ips) { this->iter = make_iter(ips); }
  IA_IPSIter(const IA_IPSIter &x) { this->iter = x.iter->clone_self(); }
  ~IA_IPSIter() { delete iter; }

  IA_IPSIter& operator=(const IA_IntPointSet &);
  IA_IPSIter& operator=(const IA_IPSIter &);

  IA_IntPointSet domain() const { return iter->domain_(); }

  int operator() (IA_IntPoint& ip) { return iter->next(ip); }
  void reset() { iter->reset(); }
};

/* sample usage:

   PointSet	blah;

   ...

   IA_IPSIter	scan(blah);
   IA_IntPoint	i;

   while (scan(i)) {
     frob(i);
   }

 */


#endif
