// Emacs: -*- C++ -*-

//
// $Log: Point.h,v $
// Revision 1.1  1993/09/15  12:26:18  thoth
// Initial revision
//

#ifndef Point_h_
#define Point_h_

template <class T> class IA_Point {
  private:
    IA_Point();
    IA_Point(const IA_Point&);
    ~IA_Point();
    IA_Point & operator=(const IA_Point &);
    // Now no automatic instantiation of Point<T> will
    // result in a viable class because the most important
    // methods are inaccessible.

    // Only specializations will be available.
};

/*

  Point<double> uses Point<int>.  If the Point<int> specialization is
not seen before its use in Point<double> then horrible things will
happen.  This can happen if you #include "IntPoint.h"

#include "IntPoint.h"
which includes "Point.h"		before the definition of Point<int>
which includes "FloatPoint.h"		which uses Point<int>

 */


#ifndef SUPPRESS_INCLUDE

/* SUPPRESS_INCLUDE is defined only by IntPoint.h and FloatPoint.h for
   the scope of this inclusion. */

/* These includes are for the benefit of template instantiations that
   need a Point.  This way if you need Point<T> you also see
   Point<int> and Point<double>, just in case T==int || T==double */

#include "IntPoint.h"
#include "FloatPoint.h"
#endif

#endif
