#!/local/bin/perl

#
#	Copyright 1993, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.
#


# $Id: generate-ops-c.perl,v 1.6 93/05/27 11:46:13 thoth Exp $

#
# $Log:	generate-ops-c.perl,v $
# Revision 1.6  93/05/27  11:46:13  thoth
# Copyright Notices
# 
# Revision 1.5  93/05/18  21:43:00  thoth
# Fixed uninitialized value bug when generating reductions.
# 
# Revision 1.4  93/04/08  13:25:40  thoth
# floats and u_chars are now passed by value.
# 
# Revision 1.3  93/03/18  13:17:03  thoth
# Operator mangling is not yet finished, but covers more cases now.
# We now handle converions from one Image type to another.
# Image-scalar operations with different basetypes
# now generate correct code (I hope).
# 
# Revision 1.2  93/03/10  13:38:55  thoth
# Operator mangling is not yet finished, but covers more cases now.
# Infix detection is now automatic.
# We now handle reducers.
# We now handle unary operations.
# 


sub is_imagearg {
	return $_[0] =~ /^I\((.*)\)$/;
}

sub basetype {
	local($_) = @_;
	if (/^I\((.*)\)$/) {
		return $1;
	} else {
		return $_;
	}
}

sub retcodeof {
	local($_) = @_;
	if (/^I\((.*)\)$/) {
		return "IA_DiscreteImage<".$1.">";
	} else {
		return $_;
	}
}

sub retcodeof {
	local($_) = @_;
	if (/^I\((.*)\)$/) {
		return "IA_DiscreteImage<".$1.">";
	} else {
		return $_;
	}
}

sub paramcodeof {
	local($_) = @_;
	if (/^I\((.*)\)$/) {
		return "const IA_DiscreteImage<".$1."> &";
	} elsif ($_ eq "u_char" ||
		 $_ eq "int" ||
		 $_ eq "float" ||
		 $_ eq "double") {
		return $_;
	} else {
		return "const ".$_." &";
	}
}

sub make_opname {
	local($_) = @_;
	s/\+/IAOPpl/g;
	s/-/IAOPmn/g;
	s/\*/IAOPmu/g;
	s:/:IAOPdv:g;

	s/%/IAOPmd/g;
	s/&&/IAOPla/g;
	s/\|\|/IAOPlo/g;
	s/!/IAOPno/g;

	s/&/IAOPba/g;
	s/\|/IAOPbo/g;
	s/\^/IAOPbx/g;
	s/~/IAOPbn/g;

	s/<</IAOPls/g;
	s/>>/IAOPrs/g;

	s/<=/IAOPle/g;
	s/</IAOPlt/g;
	s/==/IAOPeq/g;
	s/!=/IAOPne/g;
	s/>=/IAOPge/g;
	s/>/IAOPgt/g;
	return $_;
}

sub file_substitution {
	local($fname, $op, $subop, $atype, $ltype, $rtype) = @_;
	open(FILE, "<opgen-templs/$fname") ||
			die "couldn't open opgen-templs/$fname, stopped";
	local($_);
	local($/) = -1;
	$_ = <FILE>;
	s/\bOP\b/$op/g;
	s/\bSUBOP\b/$subop/g;
	$opname = &make_opname($op);
	if ($opname eq "") {
		$opname = $op;
	}
	# print STDERR $op , " = ", $opname, "\n";
	s/OPNAME/$opname/g;
	s/ATYPE/$atype/g;
	s/LTYPE/$ltype/g;
	s/RTYPE/$rtype/g;
	print $_;
	$/ = '\n';
	close(FILE);
}

print <<EOT
// Emacs -*- C++ -*-

// Machine generated include file, do not modify.

EOT
;

while (<>) {
    if (/^#/) {
	if ($' eq "\n") {
	    print $';
	} else {
	    print "// ",$';
	}
	next;
    } elsif ( /^\s+$/) {
	next;
    }

    local($bin,$pwise,$comm,$optype) = (0,0,0,0);
    print "/" x 70,
	"\n//\n",
	"// Begin operation support routines for :\n",
	"// ",$_,
	"//\n";
    split;
#    print STDERR join(" ",@_),"\n";
    while (@_) {
    	$_ = shift(@_);
	#print STDERR $_,"\n";
    	if ($_ eq "reduction") {
	    $pwise = 0;
	    $bin = 0;
	} elsif ($_ eq "pointwise") {
	    $pwise = 1;
	} elsif ($_ eq "strictrel") {
	    $pwise = 2;
	} elsif ($_ eq "conversion") {
	    $pwise = 3;

	} elsif ($_ eq "binary") {
	    $bin = 1;
    	} elsif ($_ eq "unary") {
	    $bin = 0;

	} elsif ($_ eq "commutative") {
	    $comm = 1;
	} elsif ($_ eq "non-commutative") {
	    $comm = 0;

#	} elsif ($_ eq "function") {
#	    $optype = 0;
#	} elsif ($_ eq "operator") {
#	    $optype = 1;
#	} elsif ($_ eq "opeq") {
#	    $optype = 2;
#	    $bin = 0;
#	} elsif ($_ eq "strictrel") {
#	    $optype = 3;

	} else {
	    unshift(@_,$_);
	    last;
	}
    }

    unless (@_) { next; }

    local($op) = shift(@_);

    if ($_[0] =~ /^subop=/) {
	$subopname = $subop = $';
	shift(@_);
    } else {
	$subopname = $subop = $op;
    }

    $infix = ($subop =~ s/^operator//);
    $opeq = ($subop =~ m/=$/);


    if ($pwise==0) {
	local($rtype, $argtype) = @_;
	(&is_imagearg($argtype) && !&is_imagearg($rtype)) || die "reductions are from images to scalars. stopped";
	&file_substitution("reduce_".($infix?"op":"fn")."_nz",
		$op, $subop, &basetype($rtype), &basetype($argtype),
		" #ERROR# ");
	#print $friend,&retcodeof($rtype)," ", $op, "(",
	#	&paramcodeof("I($rtype)"),");\n";
    } elsif ($pwise==3) {
	local($lhs) = @_;
	(&is_imagearg($op) && &is_imagearg($lhs)) || die "conversions must be from image to image. stopped";
	&file_substitution("conversion", $op, $op,
			&basetype($op), &basetype($lhs), " #ERROR# ");
    } elsif ($bin) {
	local($lhs, $rhs, $rtype) = @_;

	#if ($lhs eq $rhs) {
	##  (&is_imagearg($lhs) && &is_imagearg($rhs)) || die "symmetric non-image operation, stopped";
	#  &file_substitution
	#	("binary_".
	#	 ($comm ? "commutative_II":"noncommutative_II").
	#	 ( $optype ? "_operator":"_function"),
	#	$op, &basetype($rtype),
	#	&basetype($rhs),&basetype($lhs));
	#} elsif (&is_imagearg($lhs)) {
	$commcode = $comm;
	if (&is_imagearg($lhs)) {
	  if (&is_imagearg($rhs)) {
		$arity = "II";
		$commcode = $comm && (&basetype($lhs) eq &basetype($rhs));
	  } else {
		$arity = "Is";
		$commcode = $comm && (&basetype($lhs) eq $rhs);
	  }
	} else {
	  if (&is_imagearg($rhs)) {
		$arity = "sI";
		$commcode = $comm && ($lhs eq &basetype($rhs));
	  } else {
		die "Non-image operation, stopped";
	  }
	}
	&file_substitution("b".
		($pwise==2 ? "sr" : "pw")."_".
		( $commcode ? "c":"nc").
		"_${arity}_".($infix ? "op":"fn"),
		$op, $subop, &basetype($rtype),
		&basetype($lhs),&basetype($rhs));
    } else { # unary
	local($rtype, $arg) = @_;
	$retcname = &retcodeof($rtype);
	if ($opeq) {
		print "// There are none (it's inline)\n";
	} else {
		&file_substitution("upw", $op, $subop, &basetype($rtype),
			&basetype($arg),"");
	}
	# print $opname,"(", &paramcodeof($arg),");\n";
    }
    print "\n";
}

exit 0;

print<<EndOfDescription

Lines beginning with a # are ignored.


EndOfDescription
