// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	UcharDiscreteImage.h,v $
// Revision 1.4  93/05/31  15:56:45  thoth
// write_PGM now supports maxval.
// 
// Revision 1.3  93/05/27  11:22:43  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:41:34  thoth
// IDM interface for Uchar DIs.
// 
// Revision 1.1  93/03/18  11:17:14  thoth
// Initial revision
// 

#ifndef UcharDI_h_
#define UcharDI_h_

#include "DiscreteImage.h"
#include "ImageDisplayProtocol.h"

class IA_UcharDiscreteImage: public IA_DiscreteImage<u_char>
{
  public:
    IA_UcharDiscreteImage():IA_DiscreteImage<u_char>() {}

    IA_UcharDiscreteImage(const IA_UcharDiscreteImage& im)
    :IA_DiscreteImage<u_char>(im) {}

    IA_UcharDiscreteImage(IA_IntPointSet ps, u_char value)
    :IA_DiscreteImage<u_char>(ps,value) {}

    IA_UcharDiscreteImage(IA_IntPointSet ps, u_char *vp, unsigned sz,
			int giveaway=0)
    :IA_DiscreteImage<u_char>(ps, vp, sz, giveaway) {}

    IA_UcharDiscreteImage(const IA_OtherDI<u_char> &img)
    :IA_DiscreteImage<u_char>(img) {}

    IA_UcharDiscreteImage(IA_IntPointSet ps, u_char (*f)(const IA_IntPoint&))
    :IA_DiscreteImage<u_char>(ps,f) {}

    IA_UcharDiscreteImage( const IA_DiscreteImage<u_char> &d)
    :IA_DiscreteImage<u_char>(d) {}

    virtual ~IA_UcharDiscreteImage(){ }

#include	"UcharImageOps.h"

    static IA_UcharDiscreteImage read_PGM(istream &);
    static IA_UcharDiscreteImage read_PGM(const char *fname);


    ostream& write_PGM(ostream &, unsigned) const;
    ostream& write_PGM(ostream &) const;
    void write_PGM(const char *fname, unsigned) const;
    void write_PGM(const char *fname) const;


    void IDM_display(IDP::LinkID, const char *label=0);
};

inline int operator!=(const IA_UcharDiscreteImage &lhs,
	       const IA_UcharDiscreteImage &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_UcharDiscreteImage &lhs, int rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(int lhs, const IA_UcharDiscreteImage &rhs) {
    return ! (rhs == lhs);
}

// compiler clue to allow inexact matches on a function template
//ostream& operator <<(ostream&, const IA_DiscreteImage<u_char>&);


#endif
